/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.buffers;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IClientBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MutableBuffer;
import lombok.Generated;

public class MappedBuffer
extends MutableBuffer
implements IClientBuffer {
    protected long address = this.map();
    protected long position = 0L;

    public MappedBuffer(long initialSize) {
        super(initialSize, 194);
    }

    @Override
    public long reserve(long bytes, boolean occupied) {
        if (bytes <= 0L) {
            return this.address + this.position;
        }
        long oldPosition = this.position;
        long newPosition = oldPosition + bytes;
        if (occupied) {
            this.position = newPosition;
        }
        if (newPosition <= this.size) {
            return this.address + oldPosition;
        }
        this.resize(newPosition);
        return this.address + oldPosition;
    }

    @Override
    public long reserve(long bytes) {
        return this.reserve(bytes, true);
    }

    @Override
    public long addressAt(long position) {
        return this.address + position;
    }

    @Override
    public void beforeExpand() {
        this.unmap();
    }

    @Override
    public void afterExpand() {
        this.address = this.map();
    }

    public void reset() {
        this.position = 0L;
    }

    public long map() {
        return this.map(194);
    }

    @Generated
    public long getAddress() {
        return this.address;
    }

    @Generated
    public long getPosition() {
        return this.position;
    }
}

