/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;

public class AcceleratedBufferSources
implements Function<RenderType, VertexConsumer> {
    private final Map<VertexFormat, IAcceleratedBufferSource> sources;
    private final Set<VertexFormat.Mode> validModes;
    private final Set<String> invalidNames;
    private final boolean canSort;

    private AcceleratedBufferSources(Map<VertexFormat, IAcceleratedBufferSource> sources, Set<VertexFormat.Mode> validModes, Set<String> invalidNames, boolean canSort) {
        this.sources = sources;
        this.validModes = validModes;
        this.invalidNames = invalidNames;
        this.canSort = canSort;
    }

    @Override
    public VertexConsumer apply(RenderType pRenderType) {
        if (pRenderType != null && (CoreFeature.shouldForceAccelerateTranslucent() || this.canSort || !pRenderType.sortOnUpload) && this.validModes.contains(pRenderType.mode) && !this.invalidNames.contains(pRenderType.name) && this.sources.containsKey(pRenderType.format)) {
            return this.sources.get(pRenderType.format).getBuffer(pRenderType);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<VertexFormat, IAcceleratedBufferSource> sources = new Object2ObjectOpenHashMap();
        private final Set<VertexFormat.Mode> validModes = new ReferenceOpenHashSet();
        private final Set<String> invalidNames = new ObjectOpenHashSet();
        private boolean canSort = false;

        private Builder() {
        }

        public Builder source(IAcceleratedBufferSource bufferSource) {
            this.sources.putAll(Maps.asMap(bufferSource.getBufferEnvironment().getVertexFormats(), $ -> bufferSource));
            return this;
        }

        public Builder mode(VertexFormat.Mode mode) {
            this.validModes.add(mode);
            return this;
        }

        public Builder invalid(String name) {
            this.invalidNames.add(name);
            return this;
        }

        public Builder canSort() {
            this.canSort = true;
            return this;
        }

        public AcceleratedBufferSources build() {
            return new AcceleratedBufferSources(this.sources, this.validModes, this.invalidNames, this.canSort);
        }
    }
}

