/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.Sync;
import com.github.argon4w.acceleratedrendering.core.backends.VertexArray;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.DrawContextPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshUploaderPool;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.utils.LoopResetPool;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import org.apache.commons.lang3.mutable.MutableInt;

public class AcceleratedBufferSetPool
extends LoopResetPool<BufferSet, IBufferEnvironment> {
    public AcceleratedBufferSetPool(IBufferEnvironment bufferEnvironment) {
        super(CoreFeature.getPooledBufferSetSize(), bufferEnvironment);
    }

    @Override
    protected BufferSet create(IBufferEnvironment context, int i) {
        return new BufferSet(context);
    }

    @Override
    protected void reset(BufferSet bufferSet) {
    }

    @Override
    protected void delete(BufferSet bufferSet) {
        bufferSet.delete();
    }

    @Override
    protected boolean test(BufferSet bufferSet) {
        return bufferSet.isFree();
    }

    @Override
    public void init(BufferSet bufferSet) {
        bufferSet.setUsed();
    }

    @Override
    protected BufferSet fail(boolean force) {
        int index = 0;
        if (force) {
            this.expand();
        }
        BufferSet bufferSet = (BufferSet)this.at(index);
        bufferSet.waitSync();
        bufferSet.setUsed();
        return bufferSet;
    }

    public static class BufferSet {
        public static final int VERTEX_BUFFER_OUT_INDEX = 1;
        public static final int SHARING_BUFFER_INDEX = 2;
        public static final int VARYING_BUFFER_OUT_INDEX = 4;
        public static final int ELEMENT_BUFFER_INDEX = 6;
        private final MeshUploaderPool meshUploaderPool;
        private final DrawContextPool drawContextPool;
        private final ElementBufferPool elementBufferPool;
        private final MappedBuffer sharingBuffer;
        private final StagingBufferPool varyingBuffer;
        private final StagingBufferPool vertexBuffer;
        private final VertexArray vertexArray;
        private final Sync sync;
        private final MutableInt sharing;
        private final Map<RenderType, AcceleratedBufferBuilder> builders;
        private final IBufferEnvironment bufferEnvironment;
        private boolean used;
        private IMemoryLayout<VertexFormatElement> layout;

        public BufferSet(IBufferEnvironment bufferEnvironment) {
            int size = CoreFeature.getPooledElementBufferSize();
            this.meshUploaderPool = new MeshUploaderPool();
            this.drawContextPool = new DrawContextPool(size);
            this.elementBufferPool = new ElementBufferPool(size);
            this.sharingBuffer = new MappedBuffer(64L);
            this.varyingBuffer = new StagingBufferPool(size);
            this.vertexBuffer = new StagingBufferPool(size);
            this.vertexArray = new VertexArray();
            this.sync = new Sync();
            this.sharing = new MutableInt(0);
            this.builders = new Object2ObjectLinkedOpenHashMap();
            this.bufferEnvironment = bufferEnvironment;
            this.used = false;
        }

        public void reset() {
            this.vertexArray.unbindVertexArray();
            this.meshUploaderPool.reset();
            this.drawContextPool.reset();
            this.elementBufferPool.reset();
            this.varyingBuffer.reset();
            this.sharingBuffer.reset();
            this.vertexBuffer.reset();
            this.sharing.setValue(0);
            this.builders.clear();
        }

        public void bindTransformBuffers() {
            this.vertexBuffer.getBufferOut().bindBase(37074, 1);
            this.varyingBuffer.getBufferOut().bindBase(37074, 4);
            this.sharingBuffer.bindBase(37074, 2);
        }

        public void bindElementBuffer(ElementBufferPool.ElementSegment elementSegment) {
            this.elementBufferPool.getElementBufferOut().bindRange(37074, 6, elementSegment.getOffset(), elementSegment.getSize());
        }

        public void bindDrawBuffers() {
            this.vertexArray.bindVertexArray();
            ((MappedBuffer)this.drawContextPool.getContext()).bind(36671);
            if (!this.bufferEnvironment.getLayout().equals(this.layout) || this.elementBufferPool.getElementBufferOut().isResized() || this.vertexBuffer.getBufferOut().isResized()) {
                this.layout = this.bufferEnvironment.getLayout();
                this.elementBufferPool.getElementBufferOut().bind(34963);
                this.elementBufferPool.getElementBufferOut().resetResized();
                this.vertexBuffer.getBufferOut().bind(34962);
                this.vertexBuffer.getBufferOut().resetResized();
                this.bufferEnvironment.setupBufferState();
            }
        }

        public void prepare() {
            this.vertexBuffer.prepare();
            this.elementBufferPool.prepare();
        }

        public MeshUploaderPool.MeshUploader getMeshUploader() {
            return (MeshUploaderPool.MeshUploader)this.meshUploaderPool.get();
        }

        public StagingBufferPool.StagingBuffer getVertexBuffer() {
            return (StagingBufferPool.StagingBuffer)this.vertexBuffer.get();
        }

        public StagingBufferPool.StagingBuffer getVaryingBuffer() {
            return (StagingBufferPool.StagingBuffer)this.varyingBuffer.get();
        }

        public ElementBufferPool.ElementSegment getElementSegment() {
            return (ElementBufferPool.ElementSegment)this.elementBufferPool.get();
        }

        public DrawContextPool.IndirectDrawContext getDrawContext() {
            return (DrawContextPool.IndirectDrawContext)this.drawContextPool.get();
        }

        public long getVertexSize() {
            return this.bufferEnvironment.getVertexSize();
        }

        public int getSharing() {
            return this.sharing.getAndIncrement();
        }

        public long reserveSharing() {
            return this.sharingBuffer.reserve(112L);
        }

        public void setUsed() {
            this.used = true;
        }

        public void setInFlight() {
            this.used = false;
            this.sync.setSync();
        }

        protected void waitSync() {
            if (!this.sync.isSyncSet()) {
                return;
            }
            if (!this.sync.isSyncSignaled()) {
                this.sync.waitSync();
            }
            this.sync.deleteSync();
            this.sync.resetSync();
        }

        public boolean isFree() {
            if (this.used) {
                return false;
            }
            if (!this.sync.isSyncSet()) {
                return true;
            }
            if (!this.sync.isSyncSignaled()) {
                return false;
            }
            this.sync.deleteSync();
            this.sync.resetSync();
            return true;
        }

        public void delete() {
            this.meshUploaderPool.delete();
            this.drawContextPool.delete();
            this.elementBufferPool.delete();
            this.sharingBuffer.delete();
            this.varyingBuffer.delete();
            this.vertexBuffer.delete();
            this.vertexArray.delete();
            this.waitSync();
        }

        @Generated
        public Map<RenderType, AcceleratedBufferBuilder> getBuilders() {
            return this.builders;
        }

        @Generated
        public IBufferEnvironment getBufferEnvironment() {
            return this.bufferEnvironment;
        }
    }
}

