/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSetPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.DrawContextPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import org.lwjgl.opengl.GL46;

public class AcceleratedBufferSource
extends MultiBufferSource.BufferSource
implements IAcceleratedBufferSource {
    private final IBufferEnvironment bufferEnvironment;
    private final Map<RenderType, DrawContextPool.IndirectDrawContext> drawContexts;
    private final AcceleratedBufferSetPool acceleratedBufferSetPool;
    private final Set<AcceleratedBufferSetPool.BufferSet> bufferSets;
    private AcceleratedBufferSetPool.BufferSet currentBufferSet;
    private boolean used;

    public AcceleratedBufferSource(IBufferEnvironment bufferEnvironment) {
        super(null, null);
        this.bufferEnvironment = bufferEnvironment;
        this.drawContexts = new Object2ObjectLinkedOpenHashMap();
        this.acceleratedBufferSetPool = new AcceleratedBufferSetPool(this.bufferEnvironment);
        this.currentBufferSet = (AcceleratedBufferSetPool.BufferSet)this.acceleratedBufferSetPool.get(false);
        this.bufferSets = ObjectLinkedOpenHashSet.of((Object)this.currentBufferSet);
        this.used = false;
    }

    public void delete() {
        this.acceleratedBufferSetPool.delete();
    }

    public void endLastBatch() {
    }

    public void endBatch() {
    }

    public void endBatch(RenderType pRenderType) {
    }

    @Override
    public IBufferEnvironment getBufferEnvironment() {
        return this.bufferEnvironment;
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        Map<RenderType, AcceleratedBufferBuilder> builders = this.currentBufferSet.getBuilders();
        AcceleratedBufferBuilder builder = builders.get(renderType);
        if (builder != null) {
            return builder;
        }
        StagingBufferPool.StagingBuffer vertexBuffer = this.currentBufferSet.getVertexBuffer();
        StagingBufferPool.StagingBuffer varyingBuffer = this.currentBufferSet.getVaryingBuffer();
        ElementBufferPool.ElementSegment elementSegment = this.currentBufferSet.getElementSegment();
        if (vertexBuffer == null) {
            this.currentBufferSet = (AcceleratedBufferSetPool.BufferSet)this.acceleratedBufferSetPool.get(true);
            builders = this.currentBufferSet.getBuilders();
            vertexBuffer = this.currentBufferSet.getVertexBuffer();
            varyingBuffer = this.currentBufferSet.getVaryingBuffer();
            elementSegment = this.currentBufferSet.getElementSegment();
            this.bufferSets.add(this.currentBufferSet);
        }
        builder = new AcceleratedBufferBuilder(vertexBuffer, varyingBuffer, elementSegment, this.currentBufferSet, renderType);
        this.used = true;
        builders.put(renderType, builder);
        return builder;
    }

    @Override
    public void drawBuffers() {
        if (!this.used) {
            return;
        }
        for (AcceleratedBufferSetPool.BufferSet bufferSet : this.bufferSets) {
            VertexFormat.Mode mode;
            Map<RenderType, AcceleratedBufferBuilder> builders = bufferSet.getBuilders();
            int program = GL46.glGetInteger((int)35725);
            int barrier = 0;
            if (builders.isEmpty()) continue;
            this.bufferEnvironment.selectMeshUploadingProgramDispatcher().dispatch(builders.values(), bufferSet);
            this.bufferEnvironment.selectTransformProgramDispatcher().dispatch(builders.values());
            for (RenderType renderType : builders.keySet()) {
                AcceleratedBufferBuilder builder = builders.get(renderType);
                ElementBufferPool.ElementSegment elementSegment = builder.getElementSegment();
                if (builder.isEmpty()) continue;
                mode = renderType.mode;
                DrawContextPool.IndirectDrawContext drawContext = bufferSet.getDrawContext();
                elementSegment.allocateOffset();
                bufferSet.bindElementBuffer(elementSegment);
                drawContext.bindComputeBuffers(elementSegment);
                this.drawContexts.put(renderType, drawContext);
                barrier |= this.bufferEnvironment.selectProcessingProgramDispatcher(mode).dispatch(builder);
                barrier |= builder.getCullingProgramDispatcher().dispatch(builder);
            }
            GL46.glMemoryBarrier((int)barrier);
            GL46.glUseProgram((int)program);
            BufferUploader.invalidate();
            bufferSet.bindDrawBuffers();
            for (RenderType renderType : this.drawContexts.keySet()) {
                renderType.setupRenderState();
                DrawContextPool.IndirectDrawContext drawContext = this.drawContexts.get(renderType);
                ShaderInstance shader = RenderSystem.getShader();
                mode = renderType.mode;
                shader.setDefaultUniforms(mode, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
                shader.apply();
                drawContext.drawElements(mode);
                shader.clear();
                renderType.clearRenderState();
            }
            GL46.glMemoryBarrier((int)66);
            bufferSet.reset();
            bufferSet.setInFlight();
            this.drawContexts.clear();
        }
        this.used = false;
        this.currentBufferSet = (AcceleratedBufferSetPool.BufferSet)this.acceleratedBufferSetPool.get(false);
        this.bufferSets.add(this.currentBufferSet);
    }
}

