/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import com.mojang.blaze3d.vertex.VertexFormat;
import org.lwjgl.opengl.GL46;

public class DrawContextPool
extends SimpleResetPool<IndirectDrawContext, MappedBuffer> {
    public DrawContextPool(int size) {
        super(size, new MappedBuffer(20L * (long)size));
    }

    @Override
    protected IndirectDrawContext create(MappedBuffer buffer, int i) {
        return new IndirectDrawContext(i);
    }

    @Override
    protected void reset(IndirectDrawContext drawContext) {
    }

    @Override
    protected void delete(IndirectDrawContext drawContext) {
    }

    @Override
    public void delete() {
        ((MappedBuffer)this.getContext()).delete();
    }

    @Override
    public IndirectDrawContext fail() {
        this.expand();
        return (IndirectDrawContext)this.get();
    }

    public class IndirectDrawContext {
        public static final int ELEMENT_COUNT_INDEX = 0;
        public static final IMemoryInterface INDIRECT_COUNT = new SimpleMemoryInterface(0L, 4L);
        public static final IMemoryInterface INDIRECT_INSTANCE_COUNT = new SimpleMemoryInterface(4L, 4L);
        public static final IMemoryInterface INDIRECT_FIRST_INDEX = new SimpleMemoryInterface(8L, 4L);
        public static final IMemoryInterface INDIRECT_BASE_INDEX = new SimpleMemoryInterface(12L, 4L);
        public static final IMemoryInterface INDIRECT_BASE_INSTANCE = new SimpleMemoryInterface(16L, 4L);
        private final long commandOffset;

        public IndirectDrawContext(int index) {
            this.commandOffset = (long)index * 20L;
            long address = ((MappedBuffer)DrawContextPool.this.context).reserve(20L);
            INDIRECT_COUNT.putInt(address, 0);
            INDIRECT_INSTANCE_COUNT.putInt(address, 1);
            INDIRECT_FIRST_INDEX.putInt(address, 0);
            INDIRECT_BASE_INDEX.putInt(address, 0);
            INDIRECT_BASE_INSTANCE.putInt(address, 0);
        }

        public void bindComputeBuffers(ElementBufferPool.ElementSegment elementSegmentIn) {
            long elementOffset = elementSegmentIn.getOffset();
            long commandAddress = ((MappedBuffer)DrawContextPool.this.context).addressAt(this.commandOffset);
            INDIRECT_COUNT.putInt(commandAddress, 0);
            INDIRECT_FIRST_INDEX.putInt(commandAddress, (int)elementOffset / 4);
            ((MappedBuffer)DrawContextPool.this.context).bindRange(37568, 0, this.commandOffset, 4L);
        }

        public void drawElements(VertexFormat.Mode mode) {
            GL46.glDrawElementsIndirect((int)mode.asGLMode, (int)5125, (long)this.commandOffset);
        }
    }
}

