/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools;

import com.github.argon4w.acceleratedrendering.core.backends.GLConstants;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MutableBuffer;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import lombok.Generated;
import org.apache.commons.lang3.mutable.MutableLong;

public class StagingBufferPool
extends SimpleResetPool<StagingBuffer, Void> {
    private final MutableBuffer bufferOut;
    private final MutableLong bufferSegments;
    private final MutableLong bufferOutSize;
    private final MutableLong bufferOutUsedSize;

    public StagingBufferPool(int size) {
        super(size, null);
        this.bufferOut = new MutableBuffer(64L * (long)size, 256);
        this.bufferSegments = new MutableLong(0L);
        this.bufferOutSize = new MutableLong(64L * (long)size);
        this.bufferOutUsedSize = new MutableLong(0L);
    }

    public void prepare() {
        this.bufferOut.resizeTo(this.bufferOutSize.getValue());
        this.bufferSegments.setValue(0L);
    }

    @Override
    public void delete() {
        this.bufferOut.delete();
        super.delete();
    }

    @Override
    public void reset() {
        this.bufferOutUsedSize.setValue(0L);
        super.reset();
    }

    @Override
    protected StagingBuffer create(Void context, int i) {
        return new StagingBuffer();
    }

    @Override
    protected void reset(StagingBuffer stagingBuffer) {
        stagingBuffer.poolReset();
    }

    @Override
    protected void delete(StagingBuffer stagingBuffer) {
        stagingBuffer.poolDelete();
    }

    @Override
    public boolean test(StagingBuffer stagingBuffer) {
        return this.bufferOutUsedSize.addAndGet(stagingBuffer.getSize()) <= (long)GLConstants.MAX_SHADER_STORAGE_BLOCK_SIZE;
    }

    @Generated
    public MutableBuffer getBufferOut() {
        return this.bufferOut;
    }

    public class StagingBuffer
    extends MappedBuffer {
        private long offset;

        public StagingBuffer() {
            super(64L);
            this.offset = -1L;
        }

        @Override
        public void onExpand(long bytes) {
            StagingBufferPool.this.bufferOutSize.add(bytes);
            StagingBufferPool.this.bufferOutUsedSize.add(bytes);
        }

        @Override
        public void delete() {
            throw new IllegalStateException("Pooled buffers cannot be deleted directly.");
        }

        @Override
        public void reset() {
            throw new IllegalStateException("Pooled buffers cannot be reset directly.");
        }

        private void poolDelete() {
            super.delete();
        }

        private void poolReset() {
            super.reset();
        }

        public void allocateOffset(long additional) {
            this.offset = StagingBufferPool.this.bufferSegments.getAndAdd(this.position + additional);
        }

        @Generated
        public long getOffset() {
            return this.offset;
        }
    }
}

