/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshInfo;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshInfoCacheType;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import java.util.function.IntFunction;
import lombok.Generated;
import net.minecraft.util.FastColor;

public class MeshUploaderPool
extends SimpleResetPool<MeshUploader, Void> {
    public MeshUploaderPool() {
        super(128, null);
    }

    @Override
    protected MeshUploader create(Void context, int i) {
        return new MeshUploader();
    }

    @Override
    protected void reset(MeshUploader meshUploader) {
        meshUploader.reset();
    }

    @Override
    protected void delete(MeshUploader meshUploader) {
        meshUploader.delete();
    }

    @Override
    public MeshUploader fail() {
        this.expand();
        return (MeshUploader)this.get();
    }

    public static class MeshUploader
    implements IntFunction<MeshInfo> {
        public static final int MESH_INFO_BUFFER_INDEX = 8;
        public static final int EXTRA_INFO_BUFFER_INDEX = 9;
        public static final long MESH_INFO_SIZE = 20L;
        public static final long EXTRA_INFO_SIZE = 8L;
        public static final IMemoryInterface MESH_INFO_SHARING = new SimpleMemoryInterface(0L, 20L);
        public static final IMemoryInterface MESH_INFO_SHOULD_CULL = new SimpleMemoryInterface(4L, 20L);
        public static final IMemoryInterface MESH_INFO_COLOR = new SimpleMemoryInterface(8L, 20L);
        public static final IMemoryInterface MESH_INFO_UV1 = new SimpleMemoryInterface(12L, 20L);
        public static final IMemoryInterface MESH_INFO_UV2 = new SimpleMemoryInterface(16L, 20L);
        private final MappedBuffer meshInfoBuffer = new MappedBuffer(64L);
        private final MappedBuffer extraInfoBuffer = new MappedBuffer(64L);
        private final IMeshInfoCache meshInfos = MeshInfoCacheType.create(CoreFeature.getMeshInfoCacheType());
        private ServerMesh serverMesh = null;

        public void addUpload(int color, int light, int overlay, int sharing, int shouldCull) {
            this.meshInfos.setup(color, light, overlay, sharing, shouldCull);
        }

        public void upload() {
            int meshCount = this.meshInfos.getMeshCount();
            long meshInfoAddress = this.meshInfoBuffer.reserve(20L * (long)meshCount);
            long extraInfoAddress = this.extraInfoBuffer.reserve(8L * (long)meshCount);
            for (int i = 0; i < meshCount; ++i) {
                MESH_INFO_SHARING.at(i).putInt(meshInfoAddress, this.meshInfos.getSharing(i));
                MESH_INFO_SHOULD_CULL.at(i).putInt(meshInfoAddress, this.meshInfos.getShouldCull(i));
                MESH_INFO_COLOR.at(i).putInt(meshInfoAddress, FastColor.ABGR32.fromArgb32((int)this.meshInfos.getColor(i)));
                MESH_INFO_UV1.at(i).putInt(meshInfoAddress, this.meshInfos.getOverlay(i));
                MESH_INFO_UV2.at(i).putInt(meshInfoAddress, this.meshInfos.getLight(i));
            }
        }

        public void bindBuffers() {
            this.meshInfoBuffer.bindBase(37074, 8);
            this.extraInfoBuffer.bindBase(37074, 9);
        }

        public void reset() {
            this.meshInfos.reset();
            this.meshInfoBuffer.reset();
            this.extraInfoBuffer.reset();
        }

        public void delete() {
            this.meshInfos.delete();
            this.meshInfoBuffer.delete();
            this.extraInfoBuffer.delete();
        }

        @Override
        public MeshInfo apply(int value) {
            return new MeshInfo();
        }

        @Generated
        public IMeshInfoCache getMeshInfos() {
            return this.meshInfos;
        }

        @Generated
        public ServerMesh getServerMesh() {
            return this.serverMesh;
        }

        @Generated
        public void setServerMesh(ServerMesh serverMesh) {
            this.serverMesh = serverMesh;
        }
    }
}

