/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.NullMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import lombok.Generated;

public class VertexFormatMemoryLayout
implements IMemoryLayout<VertexFormatElement> {
    private final VertexFormat vertexFormat;
    private final int hashCode;
    private final long size;
    private final IMemoryInterface[] byId;

    public VertexFormatMemoryLayout(VertexFormat vertexFormat) {
        int[] offsets = vertexFormat.getOffsetsByElement();
        int count = offsets.length;
        this.vertexFormat = vertexFormat;
        this.hashCode = vertexFormat.hashCode();
        this.size = vertexFormat.getVertexSize();
        this.byId = new IMemoryInterface[count];
        for (int i = 0; i < count; ++i) {
            int offset = offsets[i];
            this.byId[i] = offset == -1 ? NullMemoryInterface.INSTANCE : new SimpleMemoryInterface(offset, this.size);
        }
    }

    @Override
    public IMemoryInterface getElement(VertexFormatElement element) {
        return this.byId[element.id()];
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String toString() {
        return this.vertexFormat.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexFormatMemoryLayout)) {
            return false;
        }
        VertexFormatMemoryLayout other = (VertexFormatMemoryLayout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.hashCode == other.hashCode;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VertexFormatMemoryLayout;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.hashCode;
        return result;
    }
}

