/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes;

import com.github.argon4w.acceleratedrendering.core.backends.GLConstants;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.EmptyMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.lwjgl.system.MemoryUtil;

public record ServerMesh(long size, long offset, IServerBuffer meshBuffer) implements IMesh
{
    @Override
    public void write(IAcceleratedVertexConsumer extension, int color, int light, int overlay) {
        extension.addServerMesh(this, color, light, overlay);
    }

    public static class Builder
    implements IMesh.Builder {
        public static final Builder INSTANCE = new Builder();
        public static final Map<IMemoryLayout<VertexFormatElement>, ReferenceArrayList<MappedBuffer>> BUFFERS = new Object2ObjectOpenHashMap();

        private Builder() {
        }

        @Override
        public IMesh build(IMeshCollector collector) {
            int vertexCount = collector.getVertexCount();
            if (vertexCount == 0) {
                return EmptyMesh.INSTANCE;
            }
            ByteBufferBuilder builder = collector.getBuffer();
            ByteBufferBuilder.Result result = builder.build();
            if (result == null) {
                builder.close();
                return EmptyMesh.INSTANCE;
            }
            ByteBuffer clientBuffer = result.byteBuffer();
            IMemoryLayout<VertexFormatElement> layout = collector.getLayout();
            ReferenceArrayList meshBuffers = BUFFERS.get(layout);
            if (meshBuffers == null) {
                meshBuffers = new ReferenceArrayList();
                BUFFERS.put(layout, (ReferenceArrayList<MappedBuffer>)meshBuffers);
            }
            MappedBuffer meshBuffer = meshBuffers.isEmpty() ? null : (MappedBuffer)meshBuffers.getLast();
            int capacity = clientBuffer.capacity();
            if (meshBuffer == null || meshBuffer.getPosition() + (long)capacity >= (long)GLConstants.MAX_SHADER_STORAGE_BLOCK_SIZE) {
                meshBuffer = new MappedBuffer(64L);
                meshBuffers.add((Object)meshBuffer);
            }
            long position = meshBuffer.getPosition();
            long srcAddress = MemoryUtil.memAddress0((Buffer)clientBuffer);
            long destAddress = meshBuffer.reserve(capacity);
            MemoryUtil.memCopy((long)srcAddress, (long)destAddress, (long)capacity);
            builder.close();
            return new ServerMesh(vertexCount, position / layout.getSize(), meshBuffer);
        }

        @Override
        public void delete() {
            for (ReferenceArrayList<MappedBuffer> buffers : BUFFERS.values()) {
                for (MappedBuffer buffer : buffers) {
                    buffer.delete();
                }
            }
        }
    }
}

