/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeShader;
import com.github.argon4w.acceleratedrendering.core.programs.LoadComputeShaderEvent;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;

public class ComputeShaderProgramLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, ShaderSource>> {
    public static final ComputeShaderProgramLoader INSTANCE = new ComputeShaderProgramLoader();
    private static final Map<ResourceLocation, ComputeProgram> COMPUTE_SHADERS = new Object2ObjectOpenHashMap();
    private static boolean LOADED = false;

    protected Map<ResourceLocation, ShaderSource> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        try {
            ImmutableMap.Builder<ResourceLocation, ShaderDefinition> builder = ((LoadComputeShaderEvent)ModLoader.postEventWithReturn((Event)new LoadComputeShaderEvent((ImmutableMap.Builder<ResourceLocation, ShaderDefinition>)ImmutableMap.builder()))).getShaderLocations();
            Object2ObjectOpenHashMap shaderSources = new Object2ObjectOpenHashMap();
            ImmutableMap shaderLocations = builder.build();
            for (ResourceLocation key : shaderLocations.keySet()) {
                ShaderDefinition definition = (ShaderDefinition)shaderLocations.get((Object)key);
                ResourceLocation resourceLocation = definition.location;
                int barrierFlags = definition.barrierFlags;
                if (resourceLocation == null) {
                    throw new IllegalStateException("Found empty shader location on: \"" + String.valueOf(key) + "\"");
                }
                Optional resource = resourceManager.getResource(resourceLocation);
                if (resource.isEmpty()) {
                    throw new IllegalStateException("Cannot found compute shader: \"" + String.valueOf(resourceLocation) + "\"");
                }
                InputStream stream = ((Resource)resource.get()).open();
                try {
                    shaderSources.put((Object)key, (Object)new ShaderSource(new String(stream.readAllBytes(), StandardCharsets.UTF_8), barrierFlags));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return shaderSources;
        }
        catch (Exception e) {
            throw new ReportedException(CrashReport.forThrowable((Throwable)e, (String)"Exception while loading compute shader"));
        }
    }

    protected void apply(Map<ResourceLocation, ShaderSource> shaderSources, ResourceManager resourceManager, ProfilerFiller profiler) {
        RenderSystem.recordRenderCall(() -> {
            try {
                for (ResourceLocation key : shaderSources.keySet()) {
                    ShaderSource source = (ShaderSource)shaderSources.get(key);
                    String shaderSource = source.source;
                    int barrierFlags = source.barrierFlags;
                    ComputeProgram program = new ComputeProgram(barrierFlags);
                    ComputeShader computeShader = new ComputeShader();
                    computeShader.setShaderSource(shaderSource);
                    computeShader.compileShader();
                    if (!computeShader.isCompiled()) {
                        throw new IllegalStateException("Shader \"" + String.valueOf(key) + "\" failed to compile because of the following errors: " + computeShader.getInfoLog());
                    }
                    program.attachShader(computeShader);
                    program.linkProgram();
                    if (!program.isLinked()) {
                        throw new IllegalStateException("Program \"" + String.valueOf(key) + "\" failed to link because of the following errors: " + program.getInfoLog());
                    }
                    computeShader.delete();
                    COMPUTE_SHADERS.put(key, program);
                }
            }
            catch (Exception e) {
                throw new ReportedException(CrashReport.forThrowable((Throwable)e, (String)"Exception while compiling/linking compute shader"));
            }
            finally {
                LOADED = true;
            }
        });
    }

    public static ComputeProgram getProgram(ResourceLocation resourceLocation) {
        ComputeProgram program = COMPUTE_SHADERS.get(resourceLocation);
        if (program == null) {
            throw new IllegalStateException("Get shader program \"" + String.valueOf(resourceLocation) + "\" too early! Program is not loaded yet!");
        }
        return program;
    }

    public static void delete() {
        for (ComputeProgram program : COMPUTE_SHADERS.values()) {
            program.delete();
        }
    }

    public static boolean isProgramsLoaded() {
        return LOADED;
    }

    public record ShaderDefinition(ResourceLocation location, int barrierFlags) {
    }

    public record ShaderSource(String source, int barrierFlags) {
    }
}

