/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.dispatchers;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSetPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshUploaderPool;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class MeshUploadingProgramDispatcher {
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    public static final int SMALL_MESH_BUFFER_INDEX = 5;
    public static final int MESH_BUFFER_INDEX = 7;
    private final Map<IServerBuffer, List<MeshUploaderPool.MeshUploader>> denseUploaders = new Reference2ObjectLinkedOpenHashMap();
    private final Map<IServerBuffer, List<MeshUploaderPool.MeshUploader>> sparseUploaders = new Reference2ObjectLinkedOpenHashMap();
    private final ComputeProgram program;
    private final Uniform meshCountUniform;
    private final Uniform meshSizeUniform;
    private final Uniform vertexOffsetUniform;
    private final Uniform varyingOffsetUniform;
    private final Uniform meshOffsetUniform;

    public MeshUploadingProgramDispatcher(ResourceLocation key) {
        this.program = ComputeShaderProgramLoader.getProgram(key);
        this.meshCountUniform = this.program.getUniform("meshCount");
        this.meshSizeUniform = this.program.getUniform("meshSize");
        this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
        this.varyingOffsetUniform = this.program.getUniform("varyingOffset");
        this.meshOffsetUniform = this.program.getUniform("meshOffset");
    }

    public void dispatch(Collection<AcceleratedBufferBuilder> builders, AcceleratedBufferSetPool.BufferSet bufferSet) {
        long vertexSize;
        StagingBufferPool.StagingBuffer varyingBuffer;
        StagingBufferPool.StagingBuffer vertexBuffer;
        TransformProgramDispatcher transformProgramDispatcher = bufferSet.getBufferEnvironment().selectTransformProgramDispatcher();
        for (AcceleratedBufferBuilder builder : builders) {
            vertexBuffer = builder.getVertexBuffer();
            varyingBuffer = builder.getVaryingBuffer();
            vertexSize = builder.getVertexSize();
            int meshVertexCount = builder.getMeshVertexCount();
            vertexBuffer.allocateOffset((long)meshVertexCount * vertexSize);
            varyingBuffer.allocateOffset((long)meshVertexCount * 16L);
        }
        bufferSet.prepare();
        bufferSet.bindTransformBuffers();
        for (AcceleratedBufferBuilder builder : builders) {
            vertexBuffer = builder.getVertexBuffer();
            varyingBuffer = builder.getVaryingBuffer();
            vertexSize = builder.getVertexSize();
            int offset = 0;
            int sparseStart = 0;
            int vertexCount = builder.getVertexCount();
            int meshVertexCount = builder.getMeshVertexCount();
            long vertexAddress = vertexBuffer.reserve((long)meshVertexCount * vertexSize);
            long varyingAddress = varyingBuffer.reserve((long)meshVertexCount * 16L);
            long vertexOffset = vertexBuffer.getOffset() / vertexSize;
            long varyingOffset = varyingBuffer.getOffset() / 16L;
            for (MeshUploaderPool.MeshUploader uploader : builder.getMeshUploaders().values()) {
                ServerMesh serverMesh = uploader.getServerMesh();
                int meshCount = uploader.getMeshInfos().getMeshCount();
                IServerBuffer buffer = serverMesh.meshBuffer();
                ReferenceArrayList dense = this.denseUploaders.get(buffer);
                ReferenceArrayList sparse = this.sparseUploaders.get(buffer);
                if (dense == null) {
                    dense = new ReferenceArrayList();
                    sparse = new ReferenceArrayList();
                    this.denseUploaders.put(buffer, (List<MeshUploaderPool.MeshUploader>)dense);
                    this.sparseUploaders.put(buffer, (List<MeshUploaderPool.MeshUploader>)sparse);
                }
                (meshCount < 128 ? sparse : dense).add(uploader);
            }
            for (IServerBuffer buffer : this.sparseUploaders.keySet()) {
                for (MeshUploaderPool.MeshUploader uploader : this.sparseUploaders.get(buffer)) {
                    ServerMesh mesh = uploader.getServerMesh();
                    IMeshInfoCache meshInfos = uploader.getMeshInfos();
                    int meshCount = meshInfos.getMeshCount();
                    long meshSize = mesh.size();
                    for (int i = 0; i < meshCount; ++i) {
                        builder.getColorOffset().at(offset).putInt(vertexAddress, FastColor.ABGR32.fromArgb32((int)meshInfos.getColor(i)));
                        builder.getUv1Offset().at(offset).putInt(vertexAddress, meshInfos.getOverlay(i));
                        builder.getUv2Offset().at(offset).putInt(vertexAddress, meshInfos.getLight(i));
                        AcceleratedBufferBuilder.VARYING_SHARING.at(offset).putInt(varyingAddress, meshInfos.getSharing(i));
                        AcceleratedBufferBuilder.VARYING_MESH.at(offset).putInt(varyingAddress, (int)mesh.offset());
                        AcceleratedBufferBuilder.VARYING_SHOULD_CULL.at(offset).putInt(varyingAddress, meshInfos.getShouldCull(i));
                        int j = 0;
                        while ((long)j < meshSize) {
                            AcceleratedBufferBuilder.VARYING_OFFSET.at(offset).at(j).putInt(varyingAddress, j);
                            ++j;
                        }
                        offset += (int)meshSize;
                    }
                }
                if (offset != 0) {
                    buffer.bindBase(37074, 5);
                    transformProgramDispatcher.dispatch(vertexBuffer, varyingBuffer, offset, (long)(sparseStart + vertexCount) + vertexOffset, (long)(sparseStart + vertexCount) + varyingOffset);
                }
                sparseStart = offset;
            }
            for (IServerBuffer buffer : this.denseUploaders.keySet()) {
                this.program.useProgram();
                buffer.bindBase(37074, 7);
                for (MeshUploaderPool.MeshUploader uploader : this.denseUploaders.get(buffer)) {
                    int meshCount = uploader.getMeshInfos().getMeshCount();
                    ServerMesh mesh = uploader.getServerMesh();
                    long meshSize = mesh.size();
                    int uploadSize = (int)((long)meshCount * meshSize);
                    uploader.upload();
                    uploader.bindBuffers();
                    this.meshCountUniform.uploadUnsignedInt(meshCount);
                    this.meshSizeUniform.uploadUnsignedInt((int)meshSize);
                    this.vertexOffsetUniform.uploadUnsignedInt((int)((long)(offset + vertexCount) + vertexOffset));
                    this.varyingOffsetUniform.uploadUnsignedInt((int)((long)(offset + vertexCount) + varyingOffset));
                    this.meshOffsetUniform.uploadUnsignedInt((int)mesh.offset());
                    this.program.dispatch((uploadSize + 128 - 1) / 128, 1, 1);
                    offset += uploadSize;
                }
            }
            for (IServerBuffer buffer : this.denseUploaders.keySet()) {
                this.denseUploaders.get(buffer).clear();
                this.sparseUploaders.get(buffer).clear();
            }
        }
        this.program.resetProgram();
        this.program.waitBarriers(transformProgramDispatcher.getBarrierFlags());
    }
}

