/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.dispatchers;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;

public class TransformProgramDispatcher {
    public static final int VERTEX_BUFFER_IN_INDEX = 0;
    public static final int VARYING_BUFFER_INDEX = 3;
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    private final ComputeProgram program;
    private final Uniform vertexCountUniform;
    private final Uniform vertexOffsetUniform;
    private final Uniform varyingOffsetUniform;

    public TransformProgramDispatcher(ResourceLocation key) {
        this.program = ComputeShaderProgramLoader.getProgram(key);
        this.vertexCountUniform = this.program.getUniform("vertexCount");
        this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
        this.varyingOffsetUniform = this.program.getUniform("varyingOffset");
    }

    public void dispatch(Collection<AcceleratedBufferBuilder> builders) {
        this.program.useProgram();
        for (AcceleratedBufferBuilder builder : builders) {
            int vertexCount = builder.getVertexCount();
            StagingBufferPool.StagingBuffer vertexBuffer = builder.getVertexBuffer();
            StagingBufferPool.StagingBuffer varyingBuffer = builder.getVaryingBuffer();
            if (vertexCount == 0) continue;
            vertexBuffer.bindBase(37074, 0);
            varyingBuffer.bindBase(37074, 3);
            this.vertexCountUniform.uploadUnsignedInt(vertexCount);
            this.vertexOffsetUniform.uploadUnsignedInt((int)(vertexBuffer.getOffset() / builder.getVertexSize()));
            this.varyingOffsetUniform.uploadUnsignedInt((int)(varyingBuffer.getOffset() / 16L));
            this.program.dispatch((vertexCount + 128 - 1) / 128, 1, 1);
        }
        this.program.resetProgram();
        this.program.waitBarriers();
    }

    public void dispatch(StagingBufferPool.StagingBuffer vertexBuffer, StagingBufferPool.StagingBuffer varyingBuffer, long vertexCount, long vertexOffset, long varyingOffset) {
        vertexBuffer.bindBase(37074, 0);
        varyingBuffer.bindBase(37074, 3);
        this.vertexCountUniform.uploadUnsignedInt((int)vertexCount);
        this.vertexOffsetUniform.uploadUnsignedInt((int)vertexOffset);
        this.varyingOffsetUniform.uploadUnsignedInt((int)varyingOffset);
        this.program.useProgram();
        this.program.dispatch((int)(vertexCount + 128L - 1L) / 128, 1, 1);
    }

    public int getBarrierFlags() {
        return this.program.getBarrierFlags();
    }
}

