/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.utils.DirectionUtils;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderContext;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SimpleBakedModel.class})
public abstract class SimpleBakedModelMixin
implements IAcceleratedBakedModel,
IAcceleratedRenderer<AcceleratedItemRenderContext> {
    @Unique
    private final Map<IBufferGraph, Int2ObjectMap<IMesh>> meshes = new Object2ObjectOpenHashMap();

    @Shadow
    public abstract List<BakedQuad> getQuads(BlockState var1, Direction var2, RandomSource var3);

    @Override
    @Unique
    public void renderItemFast(ItemStack itemStack, PoseStack poseStack, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay) {
        PoseStack.Pose pose = poseStack.last();
        extension.doRender(this, new AcceleratedItemRenderContext(itemStack, null, null), pose.pose(), pose.normal(), combinedLight, combinedOverlay, -1);
    }

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, AcceleratedItemRenderContext context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        ItemStack itemStack = context.getItemStack();
        ItemColor itemColor = context.getItemColor();
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        Int2ObjectLinkedOpenHashMap layers = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (layers != null) {
            IntIterator intIterator = layers.keySet().iterator();
            while (intIterator.hasNext()) {
                int layer = (Integer)intIterator.next();
                IMesh mesh = (IMesh)layers.get(layer);
                mesh.write(extension, this.getCustomColor(layer, itemColor.getColor(itemStack, layer)), light, overlay);
            }
            extension.endTransform();
            return;
        }
        Int2ObjectOpenHashMap culledMeshCollectors = new Int2ObjectOpenHashMap();
        layers = new Int2ObjectLinkedOpenHashMap();
        this.meshes.put(extension, (Int2ObjectMap<IMesh>)layers);
        for (Direction direction : DirectionUtils.FULL) {
            for (BakedQuad quad : this.getQuads(null, direction, null)) {
                CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(quad.getTintIndex());
                if (culledMeshCollector == null) {
                    culledMeshCollector = new CulledMeshCollector(extension.getRenderType(), extension.getBufferSet().getBufferEnvironment().getLayout());
                    culledMeshCollectors.put(quad.getTintIndex(), (Object)culledMeshCollector);
                }
                VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
                int[] data = quad.getVertices();
                for (int i = 0; i < data.length / 8; ++i) {
                    int vertexOffset = i * IQuadTransformer.STRIDE;
                    int posOffset = vertexOffset + IQuadTransformer.POSITION;
                    int colorOffset = vertexOffset + IQuadTransformer.COLOR;
                    int uv0Offset = vertexOffset + IQuadTransformer.UV0;
                    int uv2Offset = vertexOffset + IQuadTransformer.UV2;
                    int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
                    int packedNormal = data[normalOffset];
                    meshBuilder.addVertex(Float.intBitsToFloat(data[posOffset + 0]), Float.intBitsToFloat(data[posOffset + 1]), Float.intBitsToFloat(data[posOffset + 2]), data[colorOffset], Float.intBitsToFloat(data[uv0Offset + 0]), Float.intBitsToFloat(data[uv0Offset + 1]), -1, data[uv2Offset], (float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
                }
            }
        }
        IntIterator intIterator = culledMeshCollectors.keySet().iterator();
        while (intIterator.hasNext()) {
            int layer = (Integer)intIterator.next();
            CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(layer);
            culledMeshCollector.flush();
            IMesh mesh = AcceleratedItemRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
            layers.put(layer, (Object)mesh);
            mesh.write(extension, this.getCustomColor(layer, itemColor.getColor(itemStack, layer)), light, overlay);
        }
        extension.endTransform();
    }

    @Override
    @Unique
    public boolean isAccelerated() {
        return true;
    }

    @Override
    @Unique
    public boolean isAcceleratedInHand() {
        return false;
    }

    @Override
    @Unique
    public int getCustomColor(int layer, int color) {
        return layer == -1 ? -1 : color;
    }
}

