/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.text.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedBakedGlyphRenderer;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedTextRenderingFeature;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BakedGlyph.class}, priority=-2147483648)
public class BakedGlyphMixin {
    @Unique
    private final AcceleratedBakedGlyphRenderer normalRenderer = new AcceleratedBakedGlyphRenderer((BakedGlyph)this, false);
    @Unique
    private final AcceleratedBakedGlyphRenderer italicRenderer = new AcceleratedBakedGlyphRenderer((BakedGlyph)this, true);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderFast(boolean pItalic, float pX, float pY, Matrix4f pMatrix, VertexConsumer pBuffer, float pRed, float pGreen, float pBlue, float pAlpha, int pPackedLight, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(pBuffer);
        if (CoreFeature.isRenderingLevel() && AcceleratedTextRenderingFeature.isEnabled() && AcceleratedTextRenderingFeature.shouldUseAcceleratedPipeline() && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(pItalic ? this.italicRenderer : this.normalRenderer, new Vector2f(pX, pY), pMatrix, null, pPackedLight, OverlayTexture.NO_OVERLAY, FastColor.ABGR32.color((int)((int)(pAlpha * 255.0f)), (int)((int)(pBlue * 255.0f)), (int)((int)(pGreen * 255.0f)), (int)((int)(pRed * 255.0f))));
        }
    }
}

