/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.culling;

import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import com.github.argon4w.acceleratedrendering.features.culling.OrientationCullingFeature;
import com.github.argon4w.acceleratedrendering.features.culling.OrientationCullingProgramDispatcher;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class OrientationCullingProgramSelector
implements ICullingProgramSelector {
    private final ICullingProgramSelector parent;
    private final ICullingProgramDispatcher quadDispatcher;
    private final ICullingProgramDispatcher triangleDispatcher;

    public OrientationCullingProgramSelector(ICullingProgramSelector parent, ResourceLocation quadProgramKey, ResourceLocation triangleProgramKey) {
        this.parent = parent;
        this.quadDispatcher = new OrientationCullingProgramDispatcher(VertexFormat.Mode.QUADS, quadProgramKey);
        this.triangleDispatcher = new OrientationCullingProgramDispatcher(VertexFormat.Mode.TRIANGLES, triangleProgramKey);
    }

    @Override
    public ICullingProgramDispatcher select(RenderType renderType) {
        if (OrientationCullingFeature.isEnabled() && (OrientationCullingFeature.shouldIgnoreCullState() || RenderTypeUtils.isCulled(renderType))) {
            return switch (renderType.m_173186_()) {
                case VertexFormat.Mode.QUADS -> this.quadDispatcher;
                case VertexFormat.Mode.TRIANGLES -> this.triangleDispatcher;
                default -> this.parent.select(renderType);
            };
        }
        return this.parent.select(renderType);
    }
}

