/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.simplebedrockmodel.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCube;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={BedrockPart.class})
public class BedrockPartMixin
implements IAcceleratedRenderer<Void> {
    @Unique
    private static final PoseStack.Pose POSE = new PoseStack().m_85850_();
    @Unique
    private static final Vector3f[] FIXED_NORMALS = new Vector3f[]{new Vector3f(-0.0f, -1.0f, -0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(-0.0f, -0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, -0.0f, -0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
    @Shadow(remap=false)
    @Final
    public ObjectList<BedrockCube> cubes;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();

    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void compileFast(PoseStack.Pose pose, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(consumer);
        if (AcceleratedEntityRenderingFeature.isEnabled() && AcceleratedEntityRenderingFeature.shouldUseAcceleratedPipeline() && (CoreFeature.isRenderingLevel() || CoreFeature.isRenderingGui() && AcceleratedEntityRenderingFeature.shouldAccelerateInGui()) && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(this, null, pose.m_252922_(), pose.m_252943_(), texU, texV, FastColor.ARGB32.m_13660_((int)((int)(alpha * 255.0f)), (int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f))));
        }
    }

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (BedrockCube cube : this.cubes) {
            cube.compile(POSE, FIXED_NORMALS, meshBuilder, 0, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        culledMeshCollector.flush();
        mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        this.meshes.put(extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

