/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.util.FastColor;

public class SimpleMeshCollector
implements VertexConsumer,
IMeshCollector {
    private final IMemoryLayout<VertexFormatElement> layout;
    private final ByteBufferBuilder buffer;
    private final long vertexSize;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private long vertexAddress;
    private int vertexCount;

    public SimpleMeshCollector(IMemoryLayout<VertexFormatElement> layout) {
        this.layout = layout;
        this.buffer = new ByteBufferBuilder(1024);
        this.vertexSize = this.layout.getSize();
        this.posOffset = this.layout.getElement(VertexFormatElement.POSITION);
        this.colorOffset = this.layout.getElement(VertexFormatElement.COLOR);
        this.uv0Offset = this.layout.getElement(VertexFormatElement.UV);
        this.uv2Offset = this.layout.getElement(VertexFormatElement.UV2);
        this.normalOffset = this.layout.getElement(VertexFormatElement.NORMAL);
        this.vertexAddress = -1L;
        this.vertexCount = 0;
    }

    public VertexConsumer addVertex(float pX, float pY, float pZ) {
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        return this;
    }

    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        return this;
    }

    public VertexConsumer setUv(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        return this;
    }

    public VertexConsumer setUv1(int pU, int pV) {
        return this;
    }

    public VertexConsumer setUv2(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        return this;
    }

    public VertexConsumer setNormal(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        return this;
    }

    public void addVertex(float pX, float pY, float pZ, int pColor, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        this.colorOffset.putInt(this.vertexAddress, FastColor.ABGR32.fromArgb32((int)pColor));
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        this.uv2Offset.putInt(this.vertexAddress, pPackedLight);
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
    }

    @Override
    public ByteBufferBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.layout;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }
}

