/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;

public class AcceleratedBufferSources
implements IAcceleratedBufferSource {
    private final Map<VertexFormat, AcceleratedBufferSource> sources;
    private final Set<VertexFormat.Mode> validModes;
    private final Set<String> dynamicNames;
    private final boolean canSort;
    private final boolean canScroll;

    private AcceleratedBufferSources(Map<VertexFormat, AcceleratedBufferSource> sources, Set<VertexFormat.Mode> validModes, Set<String> dynamicNames, boolean canSort, boolean canScroll) {
        this.sources = sources;
        this.validModes = validModes;
        this.dynamicNames = dynamicNames;
        this.canSort = canSort;
        this.canScroll = canScroll;
    }

    @Override
    public AcceleratedBufferBuilder getBuffer(RenderType renderType, Runnable before, Runnable after, int layer) {
        if (renderType != null && (CoreFeature.shouldForceAccelerateTranslucent() || this.canSort || !renderType.f_110393_) && (CoreFeature.shouldCacheDynamicRenderType() || this.canScroll || !this.dynamicNames.contains(renderType.f_110133_)) && this.validModes.contains(renderType.m_173186_()) && this.sources.containsKey(renderType.m_110508_())) {
            return this.sources.get(renderType.m_110508_()).getBuffer(renderType, before, after, layer);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<VertexFormat, AcceleratedBufferSource> sources = new Reference2ObjectOpenHashMap();
        private final Set<VertexFormat.Mode> validModes = new ReferenceOpenHashSet();
        private final Set<String> dynamicNames = new ObjectOpenHashSet();
        private boolean canSort = false;
        private boolean canScroll = false;

        private Builder() {
        }

        public Builder source(AcceleratedBufferSource bufferSource) {
            for (VertexFormat format : bufferSource.getEnvironment().getVertexFormats()) {
                this.sources.put(format, bufferSource);
            }
            return this;
        }

        public Builder mode(VertexFormat.Mode mode) {
            this.validModes.add(mode);
            return this;
        }

        public Builder dynamic(String name) {
            this.dynamicNames.add(name);
            return this;
        }

        public Builder canSort() {
            this.canSort = true;
            return this;
        }

        public Builder canScroll() {
            this.canScroll = true;
            return this;
        }

        public AcceleratedBufferSources build() {
            return new AcceleratedBufferSources(this.sources, this.validModes, this.dynamicNames, this.canSort, this.canScroll);
        }
    }
}

