/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.meshes.EmptyMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.nio.ByteBuffer;
import java.util.Set;
import lombok.Generated;

public class ClientMesh
implements IMesh {
    private final int size;
    private final ByteBuffer vertexBuffer;

    @Override
    public void write(IAcceleratedVertexConsumer extension, int color, int light, int overlay) {
        extension.addClientMesh(this.vertexBuffer, this.size, color, light, overlay);
    }

    @Generated
    public ClientMesh(int size, ByteBuffer vertexBuffer) {
        this.size = size;
        this.vertexBuffer = vertexBuffer;
    }

    public static class Builder
    implements IMesh.Builder {
        public static final Builder INSTANCE = new Builder();
        private final Set<ByteBufferBuilder> builders = new ReferenceLinkedOpenHashSet();

        private Builder() {
        }

        @Override
        public IMesh build(IMeshCollector collector) {
            int vertexCount = collector.getVertexCount();
            if (vertexCount == 0) {
                return EmptyMesh.INSTANCE;
            }
            ByteBufferBuilder builder = collector.getBuffer();
            ByteBufferBuilder.Result result = builder.build();
            if (result == null) {
                builder.close();
                return EmptyMesh.INSTANCE;
            }
            this.builders.add(builder);
            return new ClientMesh(vertexCount, result.byteBuffer());
        }

        @Override
        public IMesh build(IMeshCollector collector, boolean forceDense) {
            return this.build(collector);
        }

        @Override
        public void delete() {
            for (ByteBufferBuilder builder : this.builders) {
                builder.close();
            }
        }
    }
}

