/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.identity;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import lombok.Generated;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class SimpleMeshData
implements IMeshData {
    private final List<Vertex> vertices = new ObjectArrayList();
    private final IMemoryLayout<VertexFormatElement> layout;

    public SimpleMeshData(IMemoryLayout<VertexFormatElement> layout) {
        this.layout = layout;
    }

    @Override
    public void addVertex(Vertex vertex) {
        Vector3f position = vertex.getPosition();
        Vector2f texCoord = vertex.getUv();
        Vector4i color = vertex.getColor();
        Vector2i light = vertex.getLight();
        Vector3f normal = vertex.getNormal();
        this.addVertex(position.x, position.y, position.z, texCoord.x, texCoord.y, color.x, color.y, color.z, color.w, light.x, light.y, normal.x, normal.y, normal.z);
    }

    @Override
    public void addVertex(float posX, float posY, float posZ, float texU, float texV, int colorR, int colorG, int colorB, int colorA, int lightU, int lightV, float normalX, float normalY, float normalZ) {
        Vertex vertex = new Vertex();
        vertex.getPosition().x = posX;
        vertex.getPosition().y = posY;
        vertex.getPosition().z = posZ;
        vertex.getUv().x = texU;
        vertex.getUv().y = texV;
        vertex.getColor().w = colorA;
        vertex.getColor().x = colorR;
        vertex.getColor().y = colorG;
        vertex.getColor().z = colorB;
        vertex.getLight().x = lightU;
        vertex.getLight().y = lightV;
        vertex.getNormal().x = normalX;
        vertex.getNormal().y = normalY;
        vertex.getNormal().z = normalZ;
        this.vertices.add(vertex);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMeshData)) {
            return false;
        }
        SimpleMeshData other = (SimpleMeshData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Vertex> this$vertices = this.vertices;
        List<Vertex> other$vertices = other.vertices;
        if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
            return false;
        }
        IMemoryLayout<VertexFormatElement> this$layout = this.layout;
        IMemoryLayout<VertexFormatElement> other$layout = other.layout;
        return !(this$layout == null ? other$layout != null : !this$layout.equals(other$layout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleMeshData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Vertex> $vertices = this.vertices;
        result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
        IMemoryLayout<VertexFormatElement> $layout = this.layout;
        result = result * 59 + ($layout == null ? 43 : $layout.hashCode());
        return result;
    }
}

