/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeShader;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderDefinition;
import com.github.argon4w.acceleratedrendering.core.programs.LoadComputeShaderEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.apache.commons.io.IOUtils;

public class ComputeShaderProgramLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, ShaderSource>> {
    public static final ComputeShaderProgramLoader INSTANCE = new ComputeShaderProgramLoader();
    private static final Map<ResourceLocation, ComputeProgram> COMPUTE_SHADERS = new Object2ObjectOpenHashMap();
    private static boolean LOADED = false;

    protected Map<ResourceLocation, ShaderSource> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        try {
            Object2ObjectOpenHashMap shaderSources = new Object2ObjectOpenHashMap();
            Map<ResourceLocation, ComputeShaderDefinition> shaderLocations = ((LoadComputeShaderEvent)ModLoader.get().postEventWithReturn((Event)new LoadComputeShaderEvent())).build();
            for (ResourceLocation key : shaderLocations.keySet()) {
                ComputeShaderDefinition definition = shaderLocations.get(key);
                ResourceLocation resourceLocation = definition.location();
                int barrierFlags = definition.barrierFlags();
                if (resourceLocation == null) {
                    throw new IllegalStateException("Found empty shader location on: \"" + key + "\"");
                }
                Optional resource = resourceManager.m_213713_(resourceLocation);
                if (resource.isEmpty()) {
                    throw new IllegalStateException("Cannot found compute shader: \"" + resourceLocation + "\"");
                }
                InputStream stream = ((Resource)resource.get()).m_215507_();
                try {
                    shaderSources.put((Object)key, (Object)new ShaderSource(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), barrierFlags));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return shaderSources;
        }
        catch (Exception e) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)"Exception while loading compute shader"));
        }
    }

    protected void apply(Map<ResourceLocation, ShaderSource> shaderSources, ResourceManager resourceManager, ProfilerFiller profiler) {
        RenderSystem.recordRenderCall(() -> {
            try {
                for (ResourceLocation key : shaderSources.keySet()) {
                    ShaderSource source = (ShaderSource)shaderSources.get(key);
                    String shaderSource = source.source;
                    int barrierFlags = source.barrierFlags;
                    ComputeProgram program = new ComputeProgram(barrierFlags);
                    ComputeShader computeShader = new ComputeShader();
                    computeShader.setShaderSource(shaderSource);
                    computeShader.compileShader();
                    if (!computeShader.isCompiled()) {
                        throw new IllegalStateException("Shader \"" + key + "\" failed to compile because of the following errors: " + computeShader.getInfoLog());
                    }
                    program.attachShader(computeShader);
                    program.linkProgram();
                    if (!program.isLinked()) {
                        throw new IllegalStateException("Program \"" + key + "\" failed to link because of the following errors: " + program.getInfoLog());
                    }
                    computeShader.delete();
                    COMPUTE_SHADERS.put(key, program);
                }
            }
            catch (Exception e) {
                throw new ReportedException(CrashReport.m_127521_((Throwable)e, (String)"Exception while compiling/linking compute shader"));
            }
            finally {
                LOADED = true;
            }
        });
    }

    public static ComputeProgram getProgram(ResourceLocation resourceLocation) {
        ComputeProgram program = COMPUTE_SHADERS.get(resourceLocation);
        if (program == null) {
            throw new IllegalStateException("Get shader program \"" + resourceLocation + "\" too early! Program is not loaded yet!");
        }
        return program;
    }

    public static void delete() {
        for (ComputeProgram program : COMPUTE_SHADERS.values()) {
            program.delete();
        }
        LOADED = false;
    }

    public static boolean isProgramsLoaded() {
        return LOADED;
    }

    public record ShaderSource(String source, int barrierFlags) {
    }
}

