/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.gui;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.states.FramebufferBindingState;
import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleTextureTarget;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedGuiGraphics;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class GuiBatchingController {
    public static final GuiBatchingController INSTANCE = new GuiBatchingController();
    private final Window window = Minecraft.m_91087_().m_91268_();
    private final IBindingState viewport = CoreFeature.createViewportState();
    private final FramebufferBindingState binding = new FramebufferBindingState();
    private final RenderTarget overlay = new SimpleTextureTarget(true);

    private GuiBatchingController() {
    }

    public void startBatching() {
        if (AcceleratedItemRenderingFeature.isEnabled() && AcceleratedItemRenderingFeature.shouldAccelerateInGui() && AcceleratedItemRenderingFeature.shouldUseGuiItemBatching() && CoreFeature.isLoaded()) {
            CoreFeature.setGuiBatching();
        }
    }

    public void flushBatching(GuiGraphics graphics) {
        if (CoreFeature.isGuiBatching()) {
            CoreFeature.resetGuiBatching();
            ((IAcceleratedGuiGraphics)graphics).flushItemBatching();
            RenderSystem.setShaderTexture((int)0, (int)this.overlay.m_83975_());
            RenderSystem.backupProjectionMatrix();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.overlay.m_83957_(this.window.m_85441_(), this.window.m_85442_(), false);
            RenderSystem.restoreProjectionMatrix();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            this.binding.record();
            this.overlay.m_83954_(Minecraft.f_91002_);
            this.binding.restore();
        }
    }

    public void resize(int newWidth, int newHeight, boolean clearError) {
        this.overlay.m_83941_(newWidth, newHeight, clearError);
    }

    public void useOverlayTarget() {
        if (CoreFeature.isGuiBatching()) {
            this.viewport.record();
            this.binding.record();
            this.overlay.m_83947_(false);
        }
    }

    public void resetOverlayTarget() {
        if (CoreFeature.isGuiBatching()) {
            this.overlay.m_83970_();
            this.binding.restore();
            this.viewport.restore();
        }
    }
}

