/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;

public class FlattenVarHandleMeshInfoCache
implements IMeshInfoCache {
    public static final VarHandle HANDLE = MethodHandles.arrayElementVarHandle(int[].class).withInvokeExactBehavior();
    public static final int MESH_INFO_SIZE = 5;
    public static final int COLOR_OFFSET = 0;
    public static final int LIGHT_OFFSET = 1;
    public static final int OVERLAY_OFFSET = 2;
    public static final int SHARING_OFFSET = 3;
    public static final int SHOULD_CULL_OFFSET = 4;
    private int[] cache = new int[this.size * 5];
    private int size = 128;
    private int count = 0;

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void delete() {
    }

    @Override
    public void setup(int color, int light, int overlay, int sharing, int shouldCull) {
        if (this.count >= this.size) {
            this.size *= 2;
            this.cache = Arrays.copyOf(this.cache, this.size * 5);
        }
        int infoIndex = this.count * 5;
        HANDLE.set(this.cache, infoIndex + 0, color);
        HANDLE.set(this.cache, infoIndex + 1, light);
        HANDLE.set(this.cache, infoIndex + 2, overlay);
        HANDLE.set(this.cache, infoIndex + 3, sharing);
        HANDLE.set(this.cache, infoIndex + 4, shouldCull);
        ++this.count;
    }

    @Override
    public int getMeshCount() {
        return this.count;
    }

    @Override
    public int getSharing(int i) {
        return HANDLE.get(this.cache, i * 5 + 3);
    }

    @Override
    public int getShouldCull(int i) {
        return HANDLE.get(this.cache, i * 5 + 4);
    }

    @Override
    public int getColor(int i) {
        return HANDLE.get(this.cache, i * 5 + 0);
    }

    @Override
    public int getLight(int i) {
        return HANDLE.get(this.cache, i * 5 + 1);
    }

    @Override
    public int getOverlay(int i) {
        return HANDLE.get(this.cache, i * 5 + 2);
    }
}

