/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.environments;

import com.github.argon4w.acceleratedrendering.core.buffers.environments.VanillaBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderPrograms;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.MeshUploadingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;

public interface IBufferEnvironment {
    public int getVertexSize();

    public Set<VertexFormat> getVertexFormats();

    public IMemoryLayout<VertexFormatElement> getLayout();

    public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher();

    public TransformProgramDispatcher selectTransformProgramDispatcher();

    public ITransformShaderProgramOverride getTransformProgramOverride(RenderType var1);

    public IUploadingShaderProgramOverride getUploadingProgramOverride(RenderType var1);

    public ICullingProgramDispatcher selectCullingProgramDispatcher(RenderType var1);

    public IPolygonProgramDispatcher selectProcessingProgramDispatcher(VertexFormat.Mode var1);

    public boolean isAccelerated(VertexFormat var1);

    public void setupBufferState();

    public static class Presets {
        public static final IBufferEnvironment BLOCK = new VanillaBufferEnvironment(DefaultVertexFormat.BLOCK, ComputeShaderPrograms.CORE_BLOCK_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_BLOCK_VERTEX_TRANSFORM_KEY);
        public static final IBufferEnvironment ENTITY = new VanillaBufferEnvironment(DefaultVertexFormat.NEW_ENTITY, ComputeShaderPrograms.CORE_ENTITY_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_ENTITY_VERTEX_TRANSFORM_KEY);
        public static final IBufferEnvironment POS = new VanillaBufferEnvironment(DefaultVertexFormat.POSITION, ComputeShaderPrograms.CORE_POS_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_POS_VERTEX_TRANSFORM_KEY);
        public static final IBufferEnvironment POS_TEX = new VanillaBufferEnvironment(DefaultVertexFormat.POSITION_TEX, ComputeShaderPrograms.CORE_POS_TEX_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_POS_TEX_VERTEX_TRANSFORM_KEY);
        public static final IBufferEnvironment POS_TEX_COLOR = new VanillaBufferEnvironment(DefaultVertexFormat.POSITION_TEX_COLOR, ComputeShaderPrograms.CORE_POS_TEX_COLOR_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_POS_TEX_COLOR_VERTEX_TRANSFORM_KEY);
        public static final IBufferEnvironment POS_COLOR_TEX_LIGHT = new VanillaBufferEnvironment(DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, ComputeShaderPrograms.CORE_POS_COLOR_TEX_LIGHT_MESH_UPLOADING_KEY, ComputeShaderPrograms.CORE_POS_COLOR_TEX_LIGHT_VERTEX_TRANSFORM_KEY);
    }
}

