/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.environments;

import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.VertexFormatMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.programs.culling.LoadCullingProgramSelectorEvent;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.MeshUploadingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverrides;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.LoadShaderProgramOverridesEvent;
import com.github.argon4w.acceleratedrendering.core.programs.processing.IPolygonProcessor;
import com.github.argon4w.acceleratedrendering.core.programs.processing.LoadPolygonProcessorEvent;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;

public class VanillaBufferEnvironment
implements IBufferEnvironment {
    private final VertexFormat vertexFormat;
    private final IMemoryLayout<VertexFormatElement> layout;
    private final IShaderProgramOverrides shaderProgramOverrides;
    private final MeshUploadingProgramDispatcher meshUploadingProgramDispatcher;
    private final TransformProgramDispatcher transformProgramDispatcher;
    private final ICullingProgramSelector cullingProgramSelector;
    private final IPolygonProcessor polygonProcessor;

    public VanillaBufferEnvironment(VertexFormat vertexFormat, ResourceLocation uploadingProgramKey, ResourceLocation transformProgramKey) {
        TransformProgramDispatcher.Default defaultTransformOverride = new TransformProgramDispatcher.Default(transformProgramKey, 16L);
        MeshUploadingProgramDispatcher.Default defaultUploadingOverride = new MeshUploadingProgramDispatcher.Default(uploadingProgramKey, 20L);
        this.vertexFormat = vertexFormat;
        this.layout = new VertexFormatMemoryLayout(vertexFormat);
        this.shaderProgramOverrides = ((LoadShaderProgramOverridesEvent)ModLoader.postEventWithReturn((Event)new LoadShaderProgramOverridesEvent(this.vertexFormat))).getOverrides(defaultTransformOverride, defaultUploadingOverride);
        this.cullingProgramSelector = ((LoadCullingProgramSelectorEvent)ModLoader.postEventWithReturn((Event)new LoadCullingProgramSelectorEvent(this.vertexFormat))).getSelector();
        this.polygonProcessor = ((LoadPolygonProcessorEvent)ModLoader.postEventWithReturn((Event)new LoadPolygonProcessorEvent(this.vertexFormat))).getProcessor();
        this.meshUploadingProgramDispatcher = new MeshUploadingProgramDispatcher();
        this.transformProgramDispatcher = new TransformProgramDispatcher();
    }

    @Override
    public void setupBufferState() {
        this.vertexFormat.setupBufferState();
    }

    @Override
    public Set<VertexFormat> getVertexFormats() {
        return Set.of(this.vertexFormat);
    }

    @Override
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.layout;
    }

    @Override
    public ITransformShaderProgramOverride getTransformProgramOverride(RenderType renderType) {
        return this.shaderProgramOverrides.getTransformOverrides().get(renderType);
    }

    @Override
    public IUploadingShaderProgramOverride getUploadingProgramOverride(RenderType renderType) {
        return this.shaderProgramOverrides.getUploadingOverrides().get(renderType);
    }

    @Override
    public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
        return this.meshUploadingProgramDispatcher;
    }

    @Override
    public TransformProgramDispatcher selectTransformProgramDispatcher() {
        return this.transformProgramDispatcher;
    }

    @Override
    public ICullingProgramDispatcher selectCullingProgramDispatcher(RenderType renderType) {
        return this.cullingProgramSelector.select(renderType);
    }

    @Override
    public IPolygonProgramDispatcher selectProcessingProgramDispatcher(VertexFormat.Mode mode) {
        return this.polygonProcessor.select(mode);
    }

    @Override
    public boolean isAccelerated(VertexFormat vertexFormat) {
        return this.vertexFormat == vertexFormat;
    }

    @Override
    public int getVertexSize() {
        return this.vertexFormat.getVertexSize();
    }
}

