/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.utils;

import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CullerUtils {
    public static boolean shouldCull(Vertex[] vertices, NativeImage texture) {
        if (texture == null) {
            return false;
        }
        if (vertices.length == 4) {
            Vector3f vertex0 = new Vector3f((Vector3fc)vertices[0].getPosition());
            Vector3f vector1 = new Vector3f((Vector3fc)vertices[1].getPosition()).sub((Vector3fc)vertex0);
            Vector3f vector2 = new Vector3f((Vector3fc)vertices[2].getPosition()).sub((Vector3fc)vertex0);
            Vector3f vector3 = new Vector3f((Vector3fc)vertices[3].getPosition()).sub((Vector3fc)vertex0);
            float length1 = vector1.cross((Vector3fc)vector2).length();
            float length2 = vector1.cross((Vector3fc)vector3).length();
            if (length1 == 0.0f && length2 == 0.0f) {
                return true;
            }
        }
        float minU = 1.0f;
        float minV = 1.0f;
        float maxU = 0.0f;
        float maxV = 0.0f;
        for (Vertex vertex : vertices) {
            Vector2f uv = vertex.getUv();
            float u = uv.x;
            float v = uv.y;
            u = u < 0.0f ? 1.0f + u : u;
            v = v < 0.0f ? 1.0f + v : v;
            minU = Math.min(minU, u);
            minV = Math.min(minV, v);
            maxU = Math.max(maxU, u);
            maxV = Math.max(maxV, v);
        }
        int width = texture.getWidth();
        int height = texture.getHeight();
        int minX = Math.max(0, Mth.floor((float)(minU * (float)texture.getWidth())));
        int minY = Math.max(0, Mth.floor((float)(minV * (float)texture.getHeight())));
        int maxX = Math.min(width, Mth.ceil((float)(maxU * (float)texture.getWidth())));
        int maxY = Math.min(height, Mth.ceil((float)(maxV * (float)texture.getHeight())));
        if (minX == maxX || minY == maxY) {
            int y;
            int x = Math.min(minX, width - 1);
            return FastColor.ABGR32.alpha((int)texture.getPixelRGBA(x, y = Math.min(minY, height - 1))) == 0;
        }
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                if (FastColor.ABGR32.alpha((int)texture.getPixelRGBA(x, y)) == 0) continue;
                return false;
            }
        }
        return true;
    }
}

