/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedVertexConsumerWrapper;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import lombok.Generated;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AcceleratedSheetedDecalTextureGenerator
extends AcceleratedVertexConsumerWrapper {
    private final VertexConsumer delegate;
    private final Matrix4f cameraInverse;
    private final Matrix3f normalInverse;
    private final float textureScale;
    private final Vector3f cachedCamera;
    private final Vector3f cachedNormal;
    private float vertexX;
    private float vertexY;
    private float vertexZ;

    public AcceleratedSheetedDecalTextureGenerator(VertexConsumer delegate, Matrix4f cameraInverse, Matrix3f normalInverse, float textureScale) {
        this.delegate = delegate;
        this.cameraInverse = cameraInverse;
        this.normalInverse = normalInverse;
        this.textureScale = textureScale;
        this.cachedCamera = new Vector3f();
        this.cachedNormal = new Vector3f();
        this.vertexX = 0.0f;
        this.vertexY = 0.0f;
        this.vertexZ = 0.0f;
    }

    @Override
    protected VertexConsumer getDelegate() {
        return this.delegate;
    }

    @Override
    public VertexConsumer decorate(VertexConsumer buffer) {
        return new AcceleratedSheetedDecalTextureGenerator(VertexConsumerExtension.getAccelerated(this.getDelegate()).decorate(buffer), this.cameraInverse, this.normalInverse, this.textureScale);
    }

    @Override
    public void addClientMesh(ByteBuffer meshBuffer, int size, int color, int light, int overlay) {
        VertexConsumerExtension.getAccelerated(this.getDelegate()).addClientMesh(meshBuffer, size, -1, light, overlay);
    }

    @Override
    public void addServerMesh(ServerMesh serverMesh, int color, int light, int overlay) {
        VertexConsumerExtension.getAccelerated(this.getDelegate()).addServerMesh(serverMesh, -1, light, overlay);
    }

    @Override
    public VertexConsumer addVertex(float pX, float pY, float pZ) {
        this.vertexX = pX;
        this.vertexY = pY;
        this.vertexZ = pZ;
        this.delegate.addVertex(pX, pY, pZ);
        return this;
    }

    @Override
    public VertexConsumer setUv(float pU, float pV) {
        return this;
    }

    @Override
    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        this.delegate.setColor(-1);
        return this;
    }

    @Override
    public VertexConsumer setNormal(float pNormalX, float pNormalY, float pNormalZ) {
        this.delegate.setNormal(pNormalX, pNormalY, pNormalZ);
        Vector3f normal = this.normalInverse.transform(pNormalX, pNormalY, pNormalZ, this.cachedNormal);
        Vector3f camera = this.cameraInverse.transformPosition(this.vertexX, this.vertexY, this.vertexZ, this.cachedCamera);
        Direction direction = Direction.getNearest((float)normal.x(), (float)normal.y(), (float)normal.z());
        camera.rotateY((float)Math.PI);
        camera.rotateX(-1.5707964f);
        camera.rotate((Quaternionfc)direction.getRotation());
        this.delegate.setUv(-camera.x() * this.textureScale, -camera.y() * this.textureScale);
        return this;
    }

    @Override
    public void addVertex(float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, float normalX, float normalY, float normalZ) {
        this.addVertex(x, y, z).setColor(color).setUv(u, v).setOverlay(packedOverlay).setLight(packedLight).setNormal(normalX, normalY, normalZ);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceleratedSheetedDecalTextureGenerator)) {
            return false;
        }
        AcceleratedSheetedDecalTextureGenerator other = (AcceleratedSheetedDecalTextureGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        VertexConsumer this$delegate = this.getDelegate();
        VertexConsumer other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        Matrix4f this$cameraInverse = this.cameraInverse;
        Matrix4f other$cameraInverse = other.cameraInverse;
        return !(this$cameraInverse == null ? other$cameraInverse != null : !this$cameraInverse.equals(other$cameraInverse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcceleratedSheetedDecalTextureGenerator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        VertexConsumer $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        Matrix4f $cameraInverse = this.cameraInverse;
        result = result * 59 + ($cameraInverse == null ? 43 : $cameraInverse.hashCode());
        return result;
    }
}

