/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.NullMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;

public class VertexFormatMemoryLayout
implements IMemoryLayout<VertexFormatElement> {
    private final int mask;
    private final long size;
    private final IMemoryInterface[] byId;
    private final int[] offsets;

    public VertexFormatMemoryLayout(VertexFormat vertexFormat) {
        int[] offsets = vertexFormat.getOffsetsByElement();
        int count = offsets.length;
        this.mask = vertexFormat.getElementsMask();
        this.size = vertexFormat.getVertexSize();
        this.byId = new IMemoryInterface[count];
        this.offsets = new int[count];
        for (int i = 0; i < count; ++i) {
            int offset = offsets[i];
            this.byId[i] = offset == -1 ? NullMemoryInterface.INSTANCE : new SimpleMemoryInterface(offset, this.size);
            this.offsets[i] = offset;
        }
    }

    @Override
    public IMemoryInterface getElement(VertexFormatElement element) {
        return this.byId[element.id()];
    }

    @Override
    public int getElementOffset(VertexFormatElement element) {
        return this.offsets[element.id()];
    }

    @Override
    public boolean containsElement(VertexFormatElement element) {
        return (this.mask & element.mask()) != 0;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

