/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.GLConstants;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.EmptyServerBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.EmptyMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceLists;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import org.lwjgl.system.MemoryUtil;

public record ServerMesh(int size, long offset, boolean forceDense, IServerBuffer meshBuffer) implements IMesh
{
    @Override
    public void write(IAcceleratedVertexConsumer extension, int color, int light, int overlay) {
        extension.addServerMesh(this, color, light, overlay);
    }

    public static class Builder
    implements IMesh.Builder {
        public static final Builder INSTANCE = new Builder();
        public static final Reference2ObjectMap<IMemoryLayout<VertexFormatElement>, List<IServerBuffer>> BUFFERS = new Reference2ObjectOpenHashMap();

        private Builder() {
        }

        @Override
        public IMesh build(IMeshCollector collector, boolean forceDense) {
            int vertexCount = collector.getVertexCount();
            if (vertexCount == 0) {
                return EmptyMesh.INSTANCE;
            }
            ByteBufferBuilder builder = collector.getBuffer();
            ByteBufferBuilder.Result result = builder.build();
            if (result == null) {
                builder.close();
                return EmptyMesh.INSTANCE;
            }
            ByteBuffer clientBuffer = result.byteBuffer();
            int capacity = clientBuffer.capacity();
            IMemoryLayout<VertexFormatElement> layout = collector.getLayout();
            List meshBuffers = (List)BUFFERS.getOrDefault(layout, null);
            MappedBuffer meshBuffer = null;
            if (meshBuffers == null) {
                meshBuffer = new MappedBuffer(64L);
                meshBuffers = new ReferenceArrayList();
                meshBuffers.add(meshBuffer);
                BUFFERS.put(layout, (Object)meshBuffers);
            } else {
                meshBuffer = (MappedBuffer)meshBuffers.getLast();
            }
            if (meshBuffer.getPosition() + (long)capacity >= (long)GLConstants.MAX_SHADER_STORAGE_BLOCK_SIZE && Builder.meshBufferCheck(collector)) {
                meshBuffer = new MappedBuffer(64L);
                meshBuffers.add(meshBuffer);
            }
            long position = meshBuffer.getPosition();
            long srcAddress = MemoryUtil.memAddress0((Buffer)clientBuffer);
            long destAddress = meshBuffer.reserve(capacity);
            MemoryUtil.memCopy((long)srcAddress, (long)destAddress, (long)capacity);
            builder.close();
            return new ServerMesh(vertexCount, position / layout.getSize(), forceDense, meshBuffer);
        }

        @Override
        public IMesh build(IMeshCollector collector) {
            return this.build(collector, false);
        }

        @Override
        public void delete() {
            for (List buffers : BUFFERS.values()) {
                for (IServerBuffer buffer : buffers) {
                    buffer.delete();
                }
            }
        }

        public static boolean meshBufferCheck(IMeshCollector collector) {
            if (CoreFeature.shouldUploadMeshImmediately()) {
                collector.getBuffer().close();
                CrashReport crashReport = CrashReport.forThrowable((Throwable)new OutOfMemoryError("Mesh buffer size exceeds limits."), (String)"Exception in building meshes.");
                CrashReportCategory category = crashReport.addCategory("Mesh being built");
                category.setDetail("Mesh type", (Object)"Server side mesh");
                category.setDetail("Mesh size (vertices)", (Object)collector.getVertexCount());
                category.setDetail("Mesh layout size (bytes)", (Object)collector.getLayout().getSize());
                category.setDetail("Mesh buffer limits (bytes)", (Object)GLConstants.MAX_SHADER_STORAGE_BLOCK_SIZE);
                throw new ReportedException(crashReport);
            }
            return true;
        }

        static {
            BUFFERS.defaultReturnValue((Object)ReferenceLists.singleton((Object)EmptyServerBuffer.INSTANCE));
        }
    }
}

