/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.core.utils.CullerUtils;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class CulledMeshCollector
implements VertexConsumer,
IMeshCollector {
    private final int polygonSize;
    private final NativeImage texture;
    private final IMemoryLayout<VertexFormatElement> layout;
    private final SimpleMeshCollector meshCollector;
    private final Vertex[] polygon;
    private int vertexIndex;

    public CulledMeshCollector(IAcceleratedVertexConsumer vertexConsumer) {
        this.polygonSize = vertexConsumer.getPolygonSize();
        this.texture = vertexConsumer.downloadTexture();
        this.layout = vertexConsumer.getLayout();
        this.meshCollector = new SimpleMeshCollector(this.layout);
        this.polygon = new Vertex[this.polygonSize];
        this.vertexIndex = -1;
    }

    public void flush() {
        if (this.vertexIndex >= this.polygonSize - 1) {
            this.vertexIndex = -1;
            if (!CullerUtils.shouldCull(this.polygon, this.texture)) {
                for (Vertex vertex : this.polygon) {
                    Vector3f vertexPosition = vertex.getPosition();
                    Vector2f vertexUV = vertex.getUv();
                    Vector3f vertexNormal = vertex.getNormal();
                    this.meshCollector.addVertex(vertexPosition.x, vertexPosition.y, vertexPosition.z, vertex.getPackedColor(), vertexUV.x, vertexUV.y, OverlayTexture.NO_OVERLAY, vertex.getPackedLight(), vertexNormal.x, vertexNormal.y, vertexNormal.z);
                }
            }
        }
    }

    public VertexConsumer addVertex(float pX, float pY, float pZ) {
        this.flush();
        this.polygon[++this.vertexIndex] = new Vertex();
        this.polygon[this.vertexIndex].getPosition().x = pX;
        this.polygon[this.vertexIndex].getPosition().y = pY;
        this.polygon[this.vertexIndex].getPosition().z = pZ;
        return this;
    }

    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getColor().x = pRed;
        this.polygon[this.vertexIndex].getColor().y = pGreen;
        this.polygon[this.vertexIndex].getColor().z = pBlue;
        this.polygon[this.vertexIndex].getColor().w = pAlpha;
        return this;
    }

    public VertexConsumer setUv(float pU, float pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getUv().x = pU;
        this.polygon[this.vertexIndex].getUv().y = pV;
        return this;
    }

    public VertexConsumer setUv1(int pU, int pV) {
        return this;
    }

    public VertexConsumer setUv2(int pU, int pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getLight().x = pU;
        this.polygon[this.vertexIndex].getLight().y = pV;
        return this;
    }

    public VertexConsumer setNormal(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getNormal().x = pNormalX;
        this.polygon[this.vertexIndex].getNormal().y = pNormalY;
        this.polygon[this.vertexIndex].getNormal().z = pNormalZ;
        return this;
    }

    @Override
    public ByteBufferBuilder getBuffer() {
        return this.meshCollector.getBuffer();
    }

    @Override
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.meshCollector.getLayout();
    }

    @Override
    public int getVertexCount() {
        return this.meshCollector.getVertexCount();
    }
}

