/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.geckolib.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.util.RenderUtil;

@Pseudo
@Mixin(value={GeoBone.class})
public class GeoBoneMixin
implements IAcceleratedRenderer<Void> {
    @Shadow
    @Final
    private List<GeoCube> cubes;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();

    @Override
    public void render(VertexConsumer vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (GeoCube cube : this.cubes) {
            PoseStack poseStack = new PoseStack();
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
            RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
            PoseStack.Pose pose = poseStack.last();
            Matrix4f cubeTransform = pose.pose();
            Matrix3f cubeNormal = pose.normal();
            for (GeoQuad quad : cube.quads()) {
                if (quad == null) continue;
                Vector3f polygonNormal = cubeNormal.transform(new Vector3f((Vector3fc)quad.normal()));
                for (GeoVertex vertex : quad.vertices()) {
                    Vector4f vertexPosition = cubeTransform.transform(new Vector4f((Vector3fc)vertex.position(), 1.0f));
                    meshBuilder.addVertex(vertexPosition.x, vertexPosition.y, vertexPosition.z, -1, vertex.texU(), vertex.texV(), overlay, 0, polygonNormal.x, polygonNormal.y, polygonNormal.z);
                }
            }
        }
        culledMeshCollector.flush();
        mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        this.meshes.put(extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

