/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedQuad;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BakedQuad.class})
public abstract class BakedQuadMixin
implements IAcceleratedBakedQuad {
    @Unique
    private static final Map<int[], Map<IBufferGraph, IMesh>> MESHES = new Reference2ObjectOpenHashMap();
    @Shadow
    @Final
    protected int[] vertices;

    @Shadow
    public abstract boolean isTinted();

    @Override
    @Unique
    public void renderFast(Matrix4f transform, Matrix3f normal, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay, int color) {
        IMesh mesh;
        Object2ObjectOpenHashMap meshes = MESHES.get(this.vertices);
        if (meshes == null) {
            meshes = new Object2ObjectOpenHashMap();
            MESHES.put(this.vertices, (Map<IBufferGraph, IMesh>)meshes);
        }
        if ((mesh = meshes.get(extension)) != null) {
            mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (int i = 0; i < this.vertices.length / 8; ++i) {
            int vertexOffset = i * IQuadTransformer.STRIDE;
            int posOffset = vertexOffset + IQuadTransformer.POSITION;
            int colorOffset = vertexOffset + IQuadTransformer.COLOR;
            int uv0Offset = vertexOffset + IQuadTransformer.UV0;
            int uv2Offset = vertexOffset + IQuadTransformer.UV2;
            int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
            int packedNormal = this.vertices[normalOffset];
            meshBuilder.addVertex(Float.intBitsToFloat(this.vertices[posOffset + 0]), Float.intBitsToFloat(this.vertices[posOffset + 1]), Float.intBitsToFloat(this.vertices[posOffset + 2]), this.vertices[colorOffset], Float.intBitsToFloat(this.vertices[uv0Offset + 0]), Float.intBitsToFloat(this.vertices[uv0Offset + 1]), combinedOverlay, this.vertices[uv2Offset], (float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
        }
        culledMeshCollector.flush();
        mesh = AcceleratedItemRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        meshes.put(extension, mesh);
        mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
    }

    @Override
    @Unique
    public int getCustomColor(int color) {
        return this.isTinted() ? color : -1;
    }
}

