/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.text.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedBakedGlyphRenderer;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedTextRenderingFeature;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BakedGlyph.class}, priority=-2147483648)
public class BakedGlyphMixin
implements IAcceleratedRenderer<BakedGlyph.Effect> {
    @Shadow
    @Final
    public float u0;
    @Shadow
    @Final
    public float v0;
    @Shadow
    @Final
    public float u1;
    @Shadow
    @Final
    public float v1;
    @Unique
    private static final Matrix3f NORMAL = new Matrix3f();
    @Unique
    private final AcceleratedBakedGlyphRenderer normalRenderer = new AcceleratedBakedGlyphRenderer((BakedGlyph)this, false);
    @Unique
    private final AcceleratedBakedGlyphRenderer italicRenderer = new AcceleratedBakedGlyphRenderer((BakedGlyph)this, true);
    @Unique
    private final Map<BakedGlyph.Effect, Map<IBufferGraph, IMesh>> effectMeshes = new Object2ObjectOpenHashMap();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderFast(boolean pItalic, float pX, float pY, Matrix4f pMatrix, VertexConsumer pBuffer, float pRed, float pGreen, float pBlue, float pAlpha, int pPackedLight, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(pBuffer);
        if (CoreFeature.isRenderingLevel() && AcceleratedTextRenderingFeature.isEnabled() && AcceleratedTextRenderingFeature.shouldUseAcceleratedPipeline() && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(pItalic ? this.italicRenderer : this.normalRenderer, new Vector2f(pX, pY), pMatrix, null, pPackedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)((int)(pAlpha * 255.0f)), (int)((int)(pRed * 255.0f)), (int)((int)(pGreen * 255.0f)), (int)((int)(pBlue * 255.0f))));
        }
    }

    @Inject(method={"renderEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffectFast(BakedGlyph.Effect effect, Matrix4f matrix, VertexConsumer buffer, int packedLight, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(buffer);
        if (CoreFeature.isRenderingLevel() && AcceleratedTextRenderingFeature.isEnabled() && AcceleratedTextRenderingFeature.shouldUseAcceleratedPipeline() && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(this, effect, matrix, NORMAL, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)((int)(effect.a * 255.0f)), (int)((int)(effect.r * 255.0f)), (int)((int)(effect.g * 255.0f)), (int)((int)(effect.b * 255.0f))));
        }
    }

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, BakedGlyph.Effect context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IMesh mesh;
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        Object2ObjectOpenHashMap meshes = this.effectMeshes.get(context);
        extension.beginTransform(transform, normal);
        if (meshes == null) {
            meshes = new Object2ObjectOpenHashMap();
            this.effectMeshes.put(context, (Map<IBufferGraph, IMesh>)meshes);
        }
        if ((mesh = meshes.get(extension)) != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        SimpleMeshCollector meshCollector = new SimpleMeshCollector(extension.getLayout());
        VertexConsumer meshBuilder = extension.decorate(meshCollector);
        Vector2f[] positions = new Vector2f[]{new Vector2f(context.x0, context.y0), new Vector2f(context.x1, context.y0), new Vector2f(context.x1, context.y1), new Vector2f(context.x0, context.y1)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(this.u0, this.v0), new Vector2f(this.u0, this.v1), new Vector2f(this.u1, this.v1), new Vector2f(this.u1, this.v0)};
        for (int i = 0; i < 4; ++i) {
            Vector3f position = new Vector3f((Vector2fc)positions[i], context.depth);
            Vector2f texCoord = texCoords[i];
            meshBuilder.addVertex(position).setColor(-1).setUv(texCoord.x, texCoord.y).setLight(0);
        }
        mesh = AcceleratedTextRenderingFeature.getMeshType().getBuilder().build(meshCollector);
        meshes.put(extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

