/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.utils.DirectionUtils;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.github.argon4w.acceleratedrendering.features.items.colors.FixedColors;
import com.github.argon4w.acceleratedrendering.features.items.colors.ILayerColors;
import com.github.argon4w.acceleratedrendering.features.items.colors.ItemLayerColors;
import com.github.argon4w.acceleratedrendering.features.items.contexts.AcceleratedModelRenderContext;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SimpleBakedModel.class})
public abstract class SimpleBakedModelMixin
implements IAcceleratedBakedModel,
IAcceleratedRenderer<AcceleratedModelRenderContext> {
    @Unique
    private final Map<IBufferGraph, Int2ObjectMap<IMesh>> meshes = new Object2ObjectOpenHashMap();

    @Shadow
    public abstract List<BakedQuad> m_213637_(BlockState var1, Direction var2, RandomSource var3);

    @Override
    @Unique
    public void renderItemFast(ItemStack itemStack, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay) {
        extension.doRender(this, new AcceleratedModelRenderContext(random, new ItemLayerColors(itemStack)), pose.m_252922_(), pose.m_252943_(), combinedLight, combinedOverlay, -1);
    }

    @Override
    public void renderBlockFast(BlockState state, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay, int color, ModelData data, RenderType renderType) {
        extension.doRender(this, new AcceleratedModelRenderContext(random, new FixedColors(color)), pose.m_252922_(), pose.m_252943_(), combinedLight, combinedOverlay, -1);
    }

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, AcceleratedModelRenderContext context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        RandomSource randomSource = context.randomSource();
        ILayerColors layerColors = context.layerColors();
        Int2ObjectAVLTreeMap layers = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (layers != null) {
            IntIterator intIterator = layers.keySet().iterator();
            while (intIterator.hasNext()) {
                int layer = (Integer)intIterator.next();
                IMesh mesh = (IMesh)layers.get(layer);
                mesh.write(extension, this.getCustomColor(layer, layerColors.getColor(layer)), light, overlay);
            }
            extension.endTransform();
            return;
        }
        Int2ObjectOpenHashMap culledMeshCollectors = new Int2ObjectOpenHashMap();
        layers = new Int2ObjectAVLTreeMap();
        this.meshes.put(extension, (Int2ObjectMap<IMesh>)layers);
        for (Direction direction : DirectionUtils.FULL) {
            for (BakedQuad quad : this.m_213637_(null, direction, randomSource)) {
                CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(quad.m_111305_());
                if (culledMeshCollector == null) {
                    culledMeshCollector = new CulledMeshCollector(extension);
                    culledMeshCollectors.put(quad.m_111305_(), (Object)culledMeshCollector);
                }
                VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
                int[] data = quad.m_111303_();
                for (int i = 0; i < data.length / 8; ++i) {
                    int vertexOffset = i * IQuadTransformer.STRIDE;
                    int posOffset = vertexOffset + IQuadTransformer.POSITION;
                    int colorOffset = vertexOffset + IQuadTransformer.COLOR;
                    int uv0Offset = vertexOffset + IQuadTransformer.UV0;
                    int uv2Offset = vertexOffset + IQuadTransformer.UV2;
                    int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
                    int packedNormal = data[normalOffset];
                    int packedColor = data[colorOffset];
                    meshBuilder.m_5954_(Float.intBitsToFloat(data[posOffset + 0]), Float.intBitsToFloat(data[posOffset + 1]), Float.intBitsToFloat(data[posOffset + 2]), (float)FastColor.ARGB32.m_13665_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)packedColor) / 255.0f, Float.intBitsToFloat(data[uv0Offset + 0]), Float.intBitsToFloat(data[uv0Offset + 1]), -1, data[uv2Offset], (float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
                }
            }
        }
        IntIterator intIterator = culledMeshCollectors.keySet().iterator();
        while (intIterator.hasNext()) {
            int layer = (Integer)intIterator.next();
            CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(layer);
            culledMeshCollector.flush();
            IMesh mesh = AcceleratedItemRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
            layers.put(layer, (Object)mesh);
            mesh.write(extension, this.getCustomColor(layer, layerColors.getColor(layer)), light, overlay);
        }
        extension.endTransform();
    }

    @Override
    @Unique
    public boolean isAccelerated() {
        return true;
    }

    @Override
    @Unique
    public boolean isAcceleratedInHand() {
        return false;
    }

    @Override
    @Unique
    public boolean isAcceleratedInGui() {
        return false;
    }

    @Override
    @Unique
    public int getCustomColor(int layer, int color) {
        return layer == -1 ? -1 : color;
    }
}

