/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.states.buffers;

import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.BlockBufferBindingCacheType;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.IBlockBufferBindingCache;
import org.lwjgl.opengl.GL46;

public class SimpleBlockBufferBindingState
implements IBindingState {
    private final IBlockBufferBindingCache bindingCache;
    private final int bindingRange;
    private final int bindingBlock;
    private final int bufferParam;
    private final int offsetParam;
    private final int sizeParam;

    public SimpleBlockBufferBindingState(BlockBufferBindingCacheType type, int bindingRange, int bindingBlock, int bufferParam, int offsetParam, int sizeParam) {
        this.bindingRange = bindingRange;
        this.bindingCache = type.create(this.bindingRange);
        this.bindingBlock = bindingBlock;
        this.bufferParam = bufferParam;
        this.offsetParam = offsetParam;
        this.sizeParam = sizeParam;
    }

    @Override
    public void delete() {
        this.bindingCache.delete();
    }

    @Override
    public void record() {
        for (int bindingPoint = 0; bindingPoint < this.bindingRange; ++bindingPoint) {
            this.bindingCache.setup(bindingPoint, GL46.glGetIntegeri((int)this.bufferParam, (int)bindingPoint), GL46.glGetIntegeri((int)this.offsetParam, (int)bindingPoint), GL46.glGetIntegeri((int)this.sizeParam, (int)bindingPoint));
        }
    }

    @Override
    public void restore() {
        for (int bindingPoint = 0; bindingPoint < this.bindingRange; ++bindingPoint) {
            int buffer = this.bindingCache.getBuffer(bindingPoint);
            long offset = this.bindingCache.getOffset(bindingPoint);
            long size = this.bindingCache.getSize(bindingPoint);
            if (offset == 0L && size == 0L) {
                GL46.glBindBufferBase((int)this.bindingBlock, (int)bindingPoint, (int)buffer);
                continue;
            }
            GL46.glBindBufferRange((int)this.bindingBlock, (int)bindingPoint, (int)buffer, (long)offset, (long)size);
        }
    }
}

