/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools;

import com.github.argon4w.acceleratedrendering.core.backends.GLConstants;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MutableBuffer;
import com.github.argon4w.acceleratedrendering.core.utils.MutableSize;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import lombok.Generated;
import org.apache.commons.lang3.mutable.MutableLong;

public class ElementBufferPool
extends SimpleResetPool<ElementSegment, Void> {
    private final MutableBuffer elementBufferOut;
    private final MutableLong elementBufferSegments;
    private final MutableLong elementBufferOutSize;
    private final MutableLong elementBufferOutUsedSize;

    public ElementBufferPool(int size) {
        super(size, null);
        this.elementBufferOut = new MutableBuffer(64L * (long)size, 256);
        this.elementBufferSegments = new MutableLong(0L);
        this.elementBufferOutSize = new MutableLong(64L * (long)size);
        this.elementBufferOutUsedSize = new MutableLong(64L * (long)size);
    }

    public void prepare() {
        this.elementBufferOut.resizeTo(this.elementBufferOutSize.getValue());
    }

    @Override
    public void reset() {
        this.elementBufferOutUsedSize.setValue(0L);
        this.elementBufferSegments.setValue(0L);
        super.reset();
    }

    @Override
    public void delete() {
        this.elementBufferOut.delete();
    }

    @Override
    protected ElementSegment create(Void value, int i) {
        return new ElementSegment();
    }

    @Override
    protected void reset(ElementSegment elementSegment) {
        elementSegment.reset();
    }

    @Override
    protected void delete(ElementSegment elementSegment) {
    }

    @Override
    public boolean test(ElementSegment elementSegment) {
        return this.elementBufferOutUsedSize.addAndGet(elementSegment.getSize()) <= (long)GLConstants.MAX_SHADER_STORAGE_BLOCK_SIZE;
    }

    @Generated
    public MutableBuffer getElementBufferOut() {
        return this.elementBufferOut;
    }

    public class ElementSegment
    extends MutableSize {
        private long bytes;
        private long offset;

        public ElementSegment() {
            super(64L);
            this.bytes = 0L;
            this.offset = -1L;
        }

        @Override
        public void onExpand(long bytes) {
            ElementBufferPool.this.elementBufferOutSize.add(bytes);
            ElementBufferPool.this.elementBufferOutUsedSize.add(bytes);
        }

        private void reset() {
            this.bytes = 0L;
        }

        public void allocateOffset() {
            this.offset = ElementBufferPool.this.elementBufferSegments.getAndAdd(this.size);
        }

        public void countElements(int count) {
            this.bytes += (long)count * 4L;
            if (this.bytes > this.size) {
                this.resize(this.bytes);
            }
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public long getOffset() {
            return this.offset;
        }
    }
}

