/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedSheetedDecalTextureGenerator;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.utils.FuzzyMatrix4f;
import com.mojang.blaze3d.vertex.VertexConsumer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class SheetedDecalTextureRenderer<T>
implements IAcceleratedRenderer<T> {
    private final IAcceleratedRenderer<T> renderer;
    private final Matrix4f cameraInverse;
    private final Matrix3f normalInverse;
    private final float textureScale;

    public SheetedDecalTextureRenderer(IAcceleratedRenderer<T> renderer, Matrix4f cameraInverse, Matrix3f normalInverse, float textureScale) {
        this.renderer = renderer;
        this.cameraInverse = cameraInverse;
        this.normalInverse = normalInverse;
        this.textureScale = textureScale;
    }

    @Override
    public void render(VertexConsumer vertexConsumer, T context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        this.renderer.render(new AcceleratedSheetedDecalTextureGenerator(vertexConsumer, new FuzzyMatrix4f(this.cameraInverse).mul((Matrix4fc)transform), new Matrix3f((Matrix3fc)this.normalInverse).mul((Matrix3fc)normal), this.textureScale), context, transform, normal, light, overlay, color);
    }
}

