/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.mixins.compatibility;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RenderType.class})
public class RenderTypeMixin {
    @Unique
    private static final Map<Pair<ResourceLocation, Integer>, RenderType> ENERGY_SWIRL = new ConcurrentHashMap<Pair<ResourceLocation, Integer>, RenderType>();
    @Unique
    private static final Map<Pair<ResourceLocation, Integer>, RenderType> BREEZE_WIND = new ConcurrentHashMap<Pair<ResourceLocation, Integer>, RenderType>();

    @WrapMethod(method={"energySwirl"})
    private static RenderType cacheEnergySwirl(ResourceLocation location, float u, float v, Operation<RenderType> original) {
        return ENERGY_SWIRL.computeIfAbsent((Pair<ResourceLocation, Integer>)Pair.of((Object)location, (Object)CoreFeature.packDynamicUV(u, v)), pair -> (RenderType)original.call(new Object[]{location, Float.valueOf(CoreFeature.unpackDynamicU((Integer)pair.getSecond())), Float.valueOf(CoreFeature.unpackDynamicV((Integer)pair.getSecond()))}));
    }

    @WrapMethod(method={"breezeWind"})
    private static RenderType cacheBreezeWind(ResourceLocation location, float u, float v, Operation<RenderType> original) {
        return BREEZE_WIND.computeIfAbsent((Pair<ResourceLocation, Integer>)Pair.of((Object)location, (Object)CoreFeature.packDynamicUV(u, v)), pair -> (RenderType)original.call(new Object[]{location, Float.valueOf(CoreFeature.unpackDynamicU((Integer)pair.getSecond())), Float.valueOf(CoreFeature.unpackDynamicV((Integer)pair.getSecond()))}));
    }
}

