/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.utils;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;

@EventBusSubscriber(modid="acceleratedrendering", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TextureUtils
implements ResourceManagerReloadListener {
    private static final TextureUtils INSTANCE = new TextureUtils();
    private static final Object2ObjectLinkedOpenHashMap<ResourceLocation, NativeImage> IMAGE_CACHE = new Object2ObjectLinkedOpenHashMap();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        IMAGE_CACHE.clear();
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    public static NativeImage downloadTexture(RenderType renderType, int mipmapLevel) {
        ResourceLocation textureLocation = RenderTypeUtils.getTextureLocation(renderType);
        if (textureLocation == null) {
            return null;
        }
        NativeImage image = (NativeImage)IMAGE_CACHE.getAndMoveToFirst((Object)textureLocation);
        if (image != null) {
            return image;
        }
        Minecraft.getInstance().getTextureManager().getTexture(textureLocation).bind();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer widthBuffer = stack.callocInt(1);
            IntBuffer heightBuffer = stack.callocInt(1);
            GL46.glGetTexLevelParameteriv((int)3553, (int)mipmapLevel, (int)4096, (IntBuffer)widthBuffer);
            GL46.glGetTexLevelParameteriv((int)3553, (int)mipmapLevel, (int)4097, (IntBuffer)heightBuffer);
            int width = widthBuffer.get(0);
            int height = heightBuffer.get(0);
            if (width == 0 || height == 0) {
                NativeImage nativeImage = null;
                return nativeImage;
            }
            NativeImage nativeImage = new NativeImage(width, height, false);
            nativeImage.downloadTexture(mipmapLevel, false);
            IMAGE_CACHE.putAndMoveToFirst((Object)textureLocation, (Object)nativeImage);
            if (IMAGE_CACHE.size() > CoreFeature.getCachedImageSize()) {
                ((NativeImage)IMAGE_CACHE.removeLast()).close();
            }
            NativeImage nativeImage2 = nativeImage;
            return nativeImage2;
        }
    }
}

