/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.gui;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.states.FramebufferBindingState;
import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleTextureTarget;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedGuiGraphics;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class GuiBatchingController {
    public static final GuiBatchingController INSTANCE = new GuiBatchingController();
    private final Window window = Minecraft.getInstance().getWindow();
    private final IBindingState viewport = CoreFeature.createViewportState();
    private final IBindingState binding = new FramebufferBindingState();
    private final RenderTarget overlay = new SimpleTextureTarget(true);

    private GuiBatchingController() {
    }

    public void startBatching() {
        if (AcceleratedItemRenderingFeature.isEnabled() && AcceleratedItemRenderingFeature.shouldAccelerateInGui() && AcceleratedItemRenderingFeature.shouldUseGuiItemBatching() && CoreFeature.isLoaded()) {
            CoreFeature.setGuiBatching();
        }
    }

    public void flushBatching(GuiGraphics graphics) {
        if (CoreFeature.isGuiBatching()) {
            CoreFeature.resetGuiBatching();
            ((IAcceleratedGuiGraphics)graphics).flushItemBatching();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.overlay.blitToScreen(this.window.getWidth(), this.window.getHeight(), false);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            this.binding.record();
            this.overlay.clear(Minecraft.ON_OSX);
            this.binding.restore();
        }
    }

    public void resize(int newWidth, int newHeight, boolean clearError) {
        this.overlay.resize(newWidth, newHeight, clearError);
    }

    public void useOverlayTarget() {
        if (CoreFeature.isGuiBatching()) {
            this.viewport.record();
            this.binding.record();
            this.overlay.bindWrite(false);
        }
    }

    public void resetOverlayTarget() {
        if (CoreFeature.isGuiBatching()) {
            this.overlay.unbindWrite();
            this.binding.restore();
            this.viewport.restore();
        }
    }
}

