/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPartBakedModel.class})
public abstract class MultipartBakedModelMixin
implements IAcceleratedBakedModel {
    @Unique
    private boolean accelerated;
    @Unique
    private boolean acceleratedInHand;
    @Unique
    private boolean acceleratedInGui;
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> selectors;

    @Shadow
    public abstract BitSet getSelectors(BlockState var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void checkAccelerationSupport(List<Pair<Predicate<BlockState>, BakedModel>> selectors, CallbackInfo ci) {
        this.accelerated = true;
        this.acceleratedInHand = true;
        this.acceleratedInGui = true;
        for (Pair<Predicate<BlockState>, BakedModel> selector : selectors) {
            IAcceleratedBakedModel extension = BakedModelExtension.getAccelerated((BakedModel)selector.getRight());
            this.accelerated &= extension.isAccelerated();
            this.acceleratedInHand &= extension.isAcceleratedInHand();
            this.acceleratedInGui &= extension.isAcceleratedInGui();
        }
    }

    @Override
    public void renderItemFast(ItemStack itemStack, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int light, int overlay) {
    }

    @Override
    public void renderBlockFast(BlockState blockState, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int light, int overlay, int color, ModelData data, RenderType renderType) {
        if (blockState == null) {
            return;
        }
        BitSet bitset = this.getSelectors(blockState);
        long seed = random.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            Pair<Predicate<BlockState>, BakedModel> selector = this.selectors.get(j);
            BakedModel selected = (BakedModel)selector.getRight();
            ChunkRenderTypeSet renderTypeSet = selected.getRenderTypes(blockState, random, data);
            if (renderType != null && !renderTypeSet.contains(renderType)) continue;
            BakedModelExtension.getAccelerated(selected).renderBlockFast(blockState, RandomSource.create((long)seed), pose, extension, light, overlay, this.getCustomColor(-1, color), data, renderType);
        }
    }

    @Override
    public int getCustomColor(int layer, int color) {
        return color;
    }

    @Override
    @Generated
    public boolean isAccelerated() {
        return this.accelerated;
    }

    @Override
    @Generated
    public boolean isAcceleratedInHand() {
        return this.acceleratedInHand;
    }

    @Override
    @Generated
    public boolean isAcceleratedInGui() {
        return this.acceleratedInGui;
    }

    @Generated
    public List<Pair<Predicate<BlockState>, BakedModel>> getSelectors() {
        return this.selectors;
    }
}

