/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.overrides;

import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverrides;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

public class LoadShaderProgramOverridesEvent
extends Event
implements IModBusEvent {
    private final VertexFormat vertexFormat;
    private final Object2ObjectOpenHashMap<RenderType, ITransformShaderProgramOverride> transformOverrides;
    private final Object2ObjectOpenHashMap<RenderType, IUploadingShaderProgramOverride> uploadingOverrides;

    public LoadShaderProgramOverridesEvent(VertexFormat vertexFormat) {
        this.vertexFormat = vertexFormat;
        this.transformOverrides = new Object2ObjectOpenHashMap();
        this.uploadingOverrides = new Object2ObjectOpenHashMap();
    }

    public void loadFor(VertexFormat vertexFormat, RenderType renderType, IShaderProgramOverride override) {
        if (this.vertexFormat == vertexFormat) {
            IShaderProgramOverride iShaderProgramOverride = override;
            Objects.requireNonNull(iShaderProgramOverride);
            IShaderProgramOverride iShaderProgramOverride2 = iShaderProgramOverride;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ITransformShaderProgramOverride.class, IUploadingShaderProgramOverride.class}, (Object)iShaderProgramOverride2, n)) {
                case 0: {
                    ITransformShaderProgramOverride transform = (ITransformShaderProgramOverride)iShaderProgramOverride2;
                    this.transformOverrides.put((Object)renderType, (Object)transform);
                    break;
                }
                case 1: {
                    IUploadingShaderProgramOverride uploading = (IUploadingShaderProgramOverride)iShaderProgramOverride2;
                    this.uploadingOverrides.put((Object)renderType, (Object)uploading);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported override type: " + override.getClass().getSimpleName());
                }
            }
        }
    }

    public IShaderProgramOverrides getOverrides(ITransformShaderProgramOverride defaultTransformOverride, IUploadingShaderProgramOverride defaultUploadingOverride) {
        return new ProgramOverrides(this.transformOverrides, this.uploadingOverrides, defaultTransformOverride, defaultUploadingOverride);
    }

    public static class ProgramOverrides
    implements IShaderProgramOverrides {
        private final Object2ObjectOpenHashMap<RenderType, ITransformShaderProgramOverride> transformOverrides;
        private final Object2ObjectOpenHashMap<RenderType, IUploadingShaderProgramOverride> uploadingOverrides;

        public ProgramOverrides(Object2ObjectOpenHashMap<RenderType, ITransformShaderProgramOverride> transformOverrides, Object2ObjectOpenHashMap<RenderType, IUploadingShaderProgramOverride> uploadingOverrides, ITransformShaderProgramOverride defaultTransformOverride, IUploadingShaderProgramOverride defaultUploadingOverride) {
            this.transformOverrides = transformOverrides;
            this.uploadingOverrides = uploadingOverrides;
            this.transformOverrides.defaultReturnValue((Object)defaultTransformOverride);
            this.uploadingOverrides.defaultReturnValue((Object)defaultUploadingOverride);
        }

        @Generated
        public Object2ObjectOpenHashMap<RenderType, ITransformShaderProgramOverride> getTransformOverrides() {
            return this.transformOverrides;
        }

        @Generated
        public Object2ObjectOpenHashMap<RenderType, IUploadingShaderProgramOverride> getUploadingOverrides() {
            return this.uploadingOverrides;
        }
    }
}

