/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.compat.iris.environments;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.VertexFormatMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.programs.culling.LoadCullingProgramSelectorEvent;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.MeshUploadingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverrides;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.LoadShaderProgramOverridesEvent;
import com.github.argon4w.acceleratedrendering.core.programs.processing.IPolygonProcessor;
import com.github.argon4w.acceleratedrendering.core.programs.processing.LoadPolygonProcessorEvent;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.List;
import java.util.Set;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class IrisBufferEnvironment
implements IBufferEnvironment {
    private final IBufferEnvironment vanillaSubSet;
    private final IBufferEnvironment irisSubSet;

    public IrisBufferEnvironment(IBufferEnvironment vanillaSubSet, VertexFormat vanillaVertexFormat, VertexFormat irisVertexFormat, ResourceLocation meshUploadingProgramKey, ResourceLocation transformProgramKey) {
        this.vanillaSubSet = vanillaSubSet;
        this.irisSubSet = new IrisSubSet(vanillaVertexFormat, irisVertexFormat, meshUploadingProgramKey, transformProgramKey);
    }

    private IBufferEnvironment getSubSet() {
        return IrisApi.getInstance().isShaderPackInUse() && ImmediateState.isRenderingLevel ? this.irisSubSet : this.vanillaSubSet;
    }

    @Override
    public void setupBufferState() {
        this.getSubSet().setupBufferState();
    }

    @Override
    public Set<VertexFormat> getVertexFormats() {
        return this.irisSubSet.getVertexFormats();
    }

    @Override
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.getSubSet().getLayout();
    }

    @Override
    public IServerBuffer getImmediateMeshBuffer() {
        return this.getSubSet().getImmediateMeshBuffer();
    }

    @Override
    public ITransformShaderProgramOverride getTransformProgramOverride(RenderType renderType) {
        return this.getSubSet().getTransformProgramOverride(renderType);
    }

    @Override
    public IUploadingShaderProgramOverride getUploadingProgramOverride(RenderType renderType) {
        return this.getSubSet().getUploadingProgramOverride(renderType);
    }

    @Override
    public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
        return this.getSubSet().selectMeshUploadingProgramDispatcher();
    }

    @Override
    public TransformProgramDispatcher selectTransformProgramDispatcher() {
        return this.getSubSet().selectTransformProgramDispatcher();
    }

    @Override
    public ICullingProgramDispatcher selectCullingProgramDispatcher(RenderType renderType) {
        return this.getSubSet().selectCullingProgramDispatcher(renderType);
    }

    @Override
    public IPolygonProgramDispatcher selectProcessingProgramDispatcher(VertexFormat.Mode mode) {
        return this.getSubSet().selectProcessingProgramDispatcher(mode);
    }

    @Override
    public boolean isAccelerated(VertexFormat vertexFormat) {
        return this.getSubSet().isAccelerated(vertexFormat);
    }

    @Override
    public int getVertexSize() {
        return this.getSubSet().getVertexSize();
    }

    public static class IrisSubSet
    implements IBufferEnvironment {
        private final VertexFormat vanillaVertexFormat;
        private final VertexFormat irisVertexFormat;
        private final IMemoryLayout<VertexFormatElement> layout;
        private final IShaderProgramOverrides shaderProgramOverrides;
        private final MeshUploadingProgramDispatcher meshUploadingProgramDispatcher;
        private final TransformProgramDispatcher transformProgramDispatcher;
        private final ICullingProgramSelector cullingProgramSelector;
        private final IPolygonProcessor polygonProcessor;

        public IrisSubSet(VertexFormat vanillaVertexFormat, VertexFormat irisVertexFormat, ResourceLocation uploadingProgramKey, ResourceLocation transformProgramKey) {
            TransformProgramDispatcher.Default defaultTransformOverride = new TransformProgramDispatcher.Default(transformProgramKey, 16L);
            MeshUploadingProgramDispatcher.Default defaultUploadingOverride = new MeshUploadingProgramDispatcher.Default(uploadingProgramKey, 28L);
            this.vanillaVertexFormat = vanillaVertexFormat;
            this.irisVertexFormat = irisVertexFormat;
            this.layout = new VertexFormatMemoryLayout(this.irisVertexFormat);
            this.shaderProgramOverrides = ((LoadShaderProgramOverridesEvent)ModLoader.get().postEventWithReturn((Event)new LoadShaderProgramOverridesEvent(this.irisVertexFormat))).getOverrides(defaultTransformOverride, defaultUploadingOverride);
            this.cullingProgramSelector = ((LoadCullingProgramSelectorEvent)ModLoader.get().postEventWithReturn((Event)new LoadCullingProgramSelectorEvent(this.irisVertexFormat))).getSelector();
            this.polygonProcessor = ((LoadPolygonProcessorEvent)ModLoader.get().postEventWithReturn((Event)new LoadPolygonProcessorEvent(this.irisVertexFormat))).getProcessor();
            this.meshUploadingProgramDispatcher = new MeshUploadingProgramDispatcher();
            this.transformProgramDispatcher = new TransformProgramDispatcher();
        }

        @Override
        public void setupBufferState() {
            this.irisVertexFormat.m_166912_();
        }

        @Override
        public boolean isAccelerated(VertexFormat vertexFormat) {
            return this.vanillaVertexFormat == vertexFormat || this.irisVertexFormat == vertexFormat;
        }

        @Override
        public Set<VertexFormat> getVertexFormats() {
            return Set.of(this.vanillaVertexFormat, this.irisVertexFormat);
        }

        @Override
        public IMemoryLayout<VertexFormatElement> getLayout() {
            return this.layout;
        }

        @Override
        public IServerBuffer getImmediateMeshBuffer() {
            return (IServerBuffer)((List)ServerMesh.Builder.BUFFERS.get(this.layout)).getFirst();
        }

        @Override
        public ITransformShaderProgramOverride getTransformProgramOverride(RenderType renderType) {
            return this.shaderProgramOverrides.getTransformOverrides().get(renderType);
        }

        @Override
        public IUploadingShaderProgramOverride getUploadingProgramOverride(RenderType renderType) {
            return this.shaderProgramOverrides.getUploadingOverrides().get(renderType);
        }

        @Override
        public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
            return this.meshUploadingProgramDispatcher;
        }

        @Override
        public TransformProgramDispatcher selectTransformProgramDispatcher() {
            return this.transformProgramDispatcher;
        }

        @Override
        public ICullingProgramDispatcher selectCullingProgramDispatcher(RenderType renderType) {
            return this.cullingProgramSelector.select(renderType);
        }

        @Override
        public IPolygonProgramDispatcher selectProcessingProgramDispatcher(VertexFormat.Mode mode) {
            return this.polygonProcessor.select(mode);
        }

        @Override
        public int getVertexSize() {
            return this.irisVertexFormat.m_86020_();
        }
    }
}

