/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.NullMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;

public class VertexFormatMemoryLayout
implements IMemoryLayout<VertexFormatElement> {
    private final long size;
    private final Reference2IntMap<VertexFormatElement> offsets;
    private final Reference2ObjectMap<VertexFormatElement, IMemoryInterface> interfaces;

    public VertexFormatMemoryLayout(VertexFormat vertexFormat) {
        ImmutableList elements = vertexFormat.m_86023_();
        int count = elements.size();
        this.size = vertexFormat.m_86020_();
        this.offsets = new Reference2IntLinkedOpenHashMap();
        this.interfaces = new Reference2ObjectOpenHashMap(count);
        for (int i = 0; i < count; ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            int offset = vertexFormat.getOffset(i);
            this.interfaces.put((Object)element, (Object)new SimpleMemoryInterface(offset, this.size));
            this.offsets.put((Object)element, offset);
        }
    }

    @Override
    public IMemoryInterface getElement(VertexFormatElement element) {
        return (IMemoryInterface)this.interfaces.getOrDefault((Object)element, (Object)NullMemoryInterface.INSTANCE);
    }

    @Override
    public int getElementOffset(VertexFormatElement element) {
        return this.offsets.getOrDefault((Object)element, -1);
    }

    @Override
    public boolean containsElement(VertexFormatElement element) {
        return this.offsets.containsKey((Object)element);
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

