/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.text;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedTextRenderingFeature;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class AcceleratedBakedGlyphRenderer
implements IAcceleratedRenderer<Vector2f> {
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    private final BakedGlyph bakedGlyph;
    private final boolean italic;

    public AcceleratedBakedGlyphRenderer(BakedGlyph bakedGlyph, boolean italic) {
        this.bakedGlyph = bakedGlyph;
        this.italic = italic;
    }

    @Override
    public void render(VertexConsumer vertexConsumer, Vector2f context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        TRANSFORM.set((Matrix4fc)transform);
        TRANSFORM.translate(context.x, context.y, 0.0f);
        extension.beginTransform(TRANSFORM, NORMAL);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        SimpleMeshCollector meshCollector = new SimpleMeshCollector(extension.getLayout());
        VertexConsumer meshBuilder = extension.decorate((VertexConsumer)meshCollector);
        float italicOffsetUp = this.italic ? 1.0f - 0.25f * this.bakedGlyph.f_95207_ : 0.0f;
        float italicOffsetDown = this.italic ? 1.0f - 0.25f * this.bakedGlyph.f_95208_ : 0.0f;
        Vector2f[] positions = new Vector2f[]{new Vector2f(this.bakedGlyph.f_95205_ + italicOffsetUp, this.bakedGlyph.f_95207_), new Vector2f(this.bakedGlyph.f_95205_ + italicOffsetDown, this.bakedGlyph.f_95208_), new Vector2f(this.bakedGlyph.f_95206_ + italicOffsetDown, this.bakedGlyph.f_95208_), new Vector2f(this.bakedGlyph.f_95206_ + italicOffsetUp, this.bakedGlyph.f_95207_)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(this.bakedGlyph.f_95201_, this.bakedGlyph.f_95203_), new Vector2f(this.bakedGlyph.f_95201_, this.bakedGlyph.f_95204_), new Vector2f(this.bakedGlyph.f_95202_, this.bakedGlyph.f_95204_), new Vector2f(this.bakedGlyph.f_95202_, this.bakedGlyph.f_95203_)};
        for (int i = 0; i < 4; ++i) {
            Vector3f position = new Vector3f((Vector2fc)positions[i], 0.0f);
            Vector2f texCoord = texCoords[i];
            meshBuilder.m_5483_((double)position.x, (double)position.y, (double)position.z).m_193479_(-1).m_7421_(texCoord.x, texCoord.y).m_85969_(0);
        }
        mesh = AcceleratedTextRenderingFeature.getMeshType().getBuilder().build(meshCollector);
        this.meshes.put(extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

