/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.programs;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeShader;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import lombok.Generated;
import org.lwjgl.opengl.GL46;

public class ComputeProgram {
    private final int programHandle = GL46.glCreateProgram();
    private final int barrierFlags;

    public ComputeProgram(int barrierFlags) {
        this.barrierFlags = barrierFlags;
    }

    public void dispatch(int countX, int countY, int countZ) {
        GL46.glDispatchCompute((int)countX, (int)countY, (int)countZ);
    }

    public void setup() {
    }

    public void linkProgram() {
        GL46.glLinkProgram((int)this.programHandle);
    }

    public boolean isLinked() {
        return GL46.glGetProgrami((int)this.programHandle, (int)35714) == 1;
    }

    public void useProgram() {
        GL46.glUseProgram((int)this.programHandle);
    }

    public void resetProgram() {
        GL46.glUseProgram((int)0);
    }

    public void attachShader(ComputeShader computeShader) {
        GL46.glAttachShader((int)this.programHandle, (int)computeShader.getShaderHandle());
    }

    public void waitBarriers() {
        GL46.glMemoryBarrier((int)this.barrierFlags);
    }

    public int getUniformLocation(String name) {
        return GL46.glGetUniformLocation((int)this.programHandle, (CharSequence)name);
    }

    public Uniform getUniform(String name) {
        return new Uniform(this.programHandle, this.getUniformLocation(name));
    }

    public String getInfoLog() {
        return GL46.glGetProgramInfoLog((int)this.programHandle);
    }

    public void delete() {
        GL46.glDeleteProgram((int)this.programHandle);
    }

    @Generated
    public int getProgramHandle() {
        return this.programHandle;
    }

    @Generated
    public int getBarrierFlags() {
        return this.barrierFlags;
    }
}

