/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.programs;

import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;

public class Uniform {
    private final int programHandle;
    private final int uniformLocation;

    public Uniform(int programHandle, int uniformLocation) {
        this.programHandle = programHandle;
        this.uniformLocation = uniformLocation;
    }

    public void uploadMatrix4f(Matrix4f matrix) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL46.glProgramUniformMatrix4fv((int)this.programHandle, (int)this.uniformLocation, (boolean)false, (FloatBuffer)matrix.get(stack.callocFloat(16)));
        }
    }

    public void uploadUnsignedInt(int value) {
        GL41.glProgramUniform1ui((int)this.programHandle, (int)this.uniformLocation, (int)value);
    }
}

