/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;

public class AcceleratedBufferSources
implements IAcceleratedBufferSource {
    private final Map<VertexFormat, AcceleratedBufferSource> sources;
    private final Set<VertexFormat.Mode> validModes;
    private final boolean supportTranslucent;
    private final boolean supportDynamic;

    private AcceleratedBufferSources(Map<VertexFormat, AcceleratedBufferSource> sources, Set<VertexFormat.Mode> validModes, boolean supportTranslucent, boolean supportDynamic) {
        this.sources = sources;
        this.validModes = validModes;
        this.supportTranslucent = supportTranslucent;
        this.supportDynamic = supportDynamic;
    }

    @Override
    public AcceleratedBufferBuilder getBuffer(RenderType renderType, Runnable before, Runnable after, int layer) {
        if (renderType != null && (CoreFeature.shouldForceAccelerateTranslucent() || this.supportTranslucent || !RenderTypeUtils.isTranslucent(renderType)) && (CoreFeature.shouldCacheDynamicRenderType() || this.supportDynamic || !RenderTypeUtils.isDynamic(renderType)) && this.validModes.contains(renderType.mode) && this.sources.containsKey(renderType.format)) {
            return this.sources.get(renderType.format).getBuffer(renderType, before, after, layer);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<VertexFormat, AcceleratedBufferSource> sources = new Reference2ObjectOpenHashMap();
        private final Set<VertexFormat.Mode> validModes = new ReferenceOpenHashSet();
        private boolean supportTranslucent = false;
        private boolean supportDynamic = false;

        private Builder() {
        }

        public Builder source(AcceleratedBufferSource bufferSource) {
            for (VertexFormat format : bufferSource.getEnvironment().getVertexFormats()) {
                this.sources.put(format, bufferSource);
            }
            return this;
        }

        public Builder mode(VertexFormat.Mode mode) {
            this.validModes.add(mode);
            return this;
        }

        public Builder supportTranslucent() {
            this.supportTranslucent = true;
            return this;
        }

        public Builder supportDynamic() {
            this.supportDynamic = true;
            return this;
        }

        public AcceleratedBufferSources build() {
            return new AcceleratedBufferSources(this.sources, this.validModes, this.supportTranslucent, this.supportDynamic);
        }
    }
}

