/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedRingBuffers;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.ILayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshUploaderPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleDynamicMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.LongSupplier;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryUtil;

public class AcceleratedBufferBuilder
implements IAcceleratedVertexConsumer,
VertexConsumer,
LongSupplier {
    public static final long SHARING_SIZE = 112L;
    public static final IMemoryInterface SHARING_TRANSFORM = new SimpleMemoryInterface(0L, 112L);
    public static final IMemoryInterface SHARING_NORMAL = new SimpleMemoryInterface(64L, 112L);
    public final IMemoryInterface varyingOffset;
    public final IMemoryInterface varyingSharing;
    public final IMemoryInterface varyingMesh;
    public final IMemoryInterface varyingShouldCull;
    private final Map<ServerMesh, MeshUploaderPool.MeshUploader> meshUploaders;
    private final StagingBufferPool.StagingBuffer vertexBuffer;
    private final StagingBufferPool.StagingBuffer varyingBuffer;
    private final ElementBufferPool.ElementSegment elementSegment;
    private final AcceleratedRingBuffers.Buffers buffer;
    private final ILayerFunction function;
    private final RenderType renderType;
    private final IMemoryLayout<VertexFormatElement> layout;
    private final IPolygonProgramDispatcher polygonProgramDispatcher;
    private final ICullingProgramDispatcher cullingProgramDispatcher;
    private final ITransformShaderProgramOverride transformOverride;
    private final IUploadingShaderProgramOverride uploadingOverride;
    private final VertexFormat.Mode mode;
    private final int polygonSize;
    private final int polygonElementCount;
    private final long vertexSize;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv1Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private final Matrix4f cachedTransformValue;
    private final Matrix3f cachedNormalValue;
    private int elementCount;
    private int meshVertexCount;
    private int vertexCount;
    private long vertexAddress;
    private long sharingAddress;
    private int activeSharing;
    private int cachedSharing;
    private boolean outdated;
    private Matrix4f cachedTransform;
    private Matrix3f cachedNormal;

    public AcceleratedBufferBuilder(StagingBufferPool.StagingBuffer vertexBuffer, StagingBufferPool.StagingBuffer varyingBuffer, ElementBufferPool.ElementSegment elementSegment, AcceleratedRingBuffers.Buffers buffer, ILayerFunction layerFunction, RenderType renderType) {
        IBufferEnvironment environment = buffer.getBufferEnvironment();
        this.varyingOffset = new SimpleDynamicMemoryInterface(0L, this);
        this.varyingSharing = new SimpleDynamicMemoryInterface(4L, this);
        this.varyingMesh = new SimpleDynamicMemoryInterface(8L, this);
        this.varyingShouldCull = new SimpleDynamicMemoryInterface(12L, this);
        this.meshUploaders = new Reference2ObjectLinkedOpenHashMap();
        this.vertexBuffer = vertexBuffer;
        this.varyingBuffer = varyingBuffer;
        this.elementSegment = elementSegment;
        this.buffer = buffer;
        this.function = layerFunction;
        this.renderType = renderType;
        this.layout = environment.getLayout();
        this.polygonProgramDispatcher = environment.selectProcessingProgramDispatcher(this.renderType.mode);
        this.cullingProgramDispatcher = environment.selectCullingProgramDispatcher(this.renderType);
        this.transformOverride = environment.getTransformProgramOverride(this.renderType);
        this.uploadingOverride = environment.getUploadingProgramOverride(this.renderType);
        this.mode = this.renderType.mode;
        this.polygonSize = this.mode.primitiveLength;
        this.polygonElementCount = this.mode.indexCount(this.polygonSize);
        this.vertexSize = this.buffer.getVertexSize();
        this.posOffset = this.layout.getElement(VertexFormatElement.POSITION);
        this.colorOffset = this.layout.getElement(VertexFormatElement.COLOR);
        this.uv0Offset = this.layout.getElement(VertexFormatElement.UV0);
        this.uv1Offset = this.layout.getElement(VertexFormatElement.UV1);
        this.uv2Offset = this.layout.getElement(VertexFormatElement.UV2);
        this.normalOffset = this.layout.getElement(VertexFormatElement.NORMAL);
        this.cachedTransformValue = new Matrix4f();
        this.cachedNormalValue = new Matrix3f();
        this.elementCount = 0;
        this.meshVertexCount = 0;
        this.vertexCount = 0;
        this.vertexAddress = -1L;
        this.sharingAddress = -1L;
        this.activeSharing = -1;
        this.cachedSharing = -1;
        this.cachedTransform = null;
        this.cachedNormal = null;
    }

    public VertexConsumer addVertex(PoseStack.Pose pPose, float pX, float pY, float pZ) {
        this.beginTransform(pPose.pose(), pPose.normal());
        return this.addVertex(pX, pY, pZ);
    }

    public VertexConsumer addVertex(float pX, float pY, float pZ) {
        long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize());
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize());
        this.vertexAddress = vertexAddress;
        this.posOffset.putFloat(vertexAddress + 0L, pX);
        this.posOffset.putFloat(vertexAddress + 4L, pY);
        this.posOffset.putFloat(vertexAddress + 8L, pZ);
        this.varyingOffset.putInt(varyingAddress, 0);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(vertexAddress, 0);
        ++this.vertexCount;
        ++this.elementCount;
        if (this.elementCount >= this.polygonSize) {
            this.elementSegment.countElements(this.polygonElementCount);
            this.elementCount = 0;
            this.activeSharing = -1;
        }
        return this;
    }

    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        return this;
    }

    public VertexConsumer setUv(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        return this;
    }

    public VertexConsumer setUv1(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv1Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv1Offset.putShort(this.vertexAddress + 2L, (short)pV);
        return this;
    }

    public VertexConsumer setUv2(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        return this;
    }

    public VertexConsumer setNormal(PoseStack.Pose pPose, float pNormalX, float pNormalY, float pNormalZ) {
        Matrix3f normal = pPose.normal();
        if (this.activeSharing == -1) {
            return super.setNormal(pPose, pNormalX, pNormalY, pNormalZ);
        }
        if (!normal.equals((Object)this.cachedNormal)) {
            SHARING_NORMAL.putMatrix3f(this.sharingAddress, normal);
        }
        return this.setNormal(pNormalX, pNormalY, pNormalZ);
    }

    public VertexConsumer setNormal(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        return this;
    }

    public void addVertex(float pX, float pY, float pZ, int pColor, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize());
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize());
        this.posOffset.putFloat(vertexAddress + 0L, pX);
        this.posOffset.putFloat(vertexAddress + 4L, pY);
        this.posOffset.putFloat(vertexAddress + 8L, pZ);
        this.colorOffset.putInt(vertexAddress, FastColor.ABGR32.fromArgb32((int)pColor));
        this.uv0Offset.putFloat(vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(vertexAddress + 4L, pV);
        this.uv1Offset.putInt(vertexAddress, pPackedOverlay);
        this.uv2Offset.putInt(vertexAddress, pPackedLight);
        this.normalOffset.putNormal(vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(vertexAddress + 2L, pNormalZ);
        this.varyingOffset.putInt(varyingAddress, 0);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(varyingAddress, 0);
        ++this.vertexCount;
        ++this.elementCount;
        if (this.elementCount >= this.polygonSize) {
            this.elementSegment.countElements(this.polygonElementCount);
            this.elementCount = 0;
            this.activeSharing = -1;
        }
    }

    @Override
    public void beginTransform(Matrix4f transform, Matrix3f normal) {
        if (CoreFeature.shouldCacheIdenticalPose() && transform.equals((Object)this.cachedTransform) && normal.equals((Object)this.cachedNormal)) {
            this.activeSharing = this.cachedSharing;
            return;
        }
        this.cachedTransform = this.cachedTransformValue.set((Matrix4fc)transform);
        this.cachedNormal = this.cachedNormalValue.set((Matrix3fc)normal);
        this.sharingAddress = this.buffer.reserveSharing();
        this.activeSharing = this.cachedSharing = this.buffer.getSharing();
        SHARING_TRANSFORM.putMatrix4f(this.sharingAddress, transform);
        SHARING_NORMAL.putMatrix3f(this.sharingAddress, normal);
    }

    @Override
    public void endTransform() {
        this.cachedTransform = null;
        this.cachedNormal = null;
        this.activeSharing = -1;
        this.cachedSharing = -1;
    }

    @Override
    public void addClientMesh(ByteBuffer meshBuffer, int size, int color, int light, int overlay) {
        long bufferSize = this.vertexSize * (long)size;
        long vertexAddress = this.vertexBuffer.reserve(bufferSize);
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize() * (long)size);
        MemoryUtil.memCopy((long)MemoryUtil.memAddress0((Buffer)meshBuffer), (long)vertexAddress, (long)bufferSize);
        this.colorOffset.putInt(vertexAddress, FastColor.ABGR32.fromArgb32((int)color));
        this.uv1Offset.putInt(vertexAddress, overlay);
        this.uv2Offset.putInt(vertexAddress, light);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(varyingAddress, 0);
        for (int i = 0; i < size; ++i) {
            this.varyingOffset.at(i).putInt(varyingAddress, i);
        }
        this.elementSegment.countElements(this.mode.indexCount(size));
        this.vertexCount += size;
    }

    @Override
    public void addServerMesh(ServerMesh serverMesh, int color, int light, int overlay) {
        if (CoreFeature.shouldUploadMeshImmediately()) {
            int meshSize = serverMesh.size();
            long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize() * (long)meshSize);
            long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize() * (long)meshSize);
            this.colorOffset.putInt(vertexAddress, FastColor.ABGR32.fromArgb32((int)color));
            this.uv1Offset.putInt(vertexAddress, overlay);
            this.uv2Offset.putInt(vertexAddress, light);
            this.varyingSharing.putInt(varyingAddress, this.activeSharing);
            this.varyingMesh.putInt(varyingAddress, serverMesh.offset());
            this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
            this.transformOverride.uploadVarying(varyingAddress, 0);
            for (int i = 0; i < meshSize; ++i) {
                this.varyingOffset.at(i).putInt(varyingAddress, i);
            }
            this.elementSegment.countElements(this.mode.indexCount(meshSize));
            this.vertexCount += meshSize;
            return;
        }
        int meshSize = serverMesh.size();
        MeshUploaderPool.MeshUploader meshUploader = this.meshUploaders.get(serverMesh);
        if (meshUploader == null) {
            meshUploader = this.buffer.getMeshUploader();
            meshUploader.setServerMesh(serverMesh);
            meshUploader.setUploadingOverride(this.uploadingOverride);
            this.meshUploaders.put(serverMesh, meshUploader);
        }
        this.elementSegment.countElements(this.mode.indexCount(meshSize));
        this.meshVertexCount += meshSize;
        meshUploader.addUpload(color, light, overlay, this.activeSharing, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
    }

    @Override
    public <T> void doRender(IAcceleratedRenderer<T> renderer, T context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        renderer.render(this, context, transform, normal, light, overlay, color);
    }

    @Override
    public VertexConsumer decorate(VertexConsumer buffer) {
        return buffer;
    }

    @Override
    public boolean isAccelerated() {
        return true;
    }

    @Override
    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public long getAsLong() {
        return this.getVaryingSize();
    }

    public long getVaryingSize() {
        return this.transformOverride.getVaryingSize();
    }

    public int getTotalVertexCount() {
        return this.vertexCount + this.meshVertexCount;
    }

    public boolean isEmpty() {
        return this.getTotalVertexCount() == 0;
    }

    public void setOutdated() {
        this.outdated = true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceleratedBufferBuilder)) {
            return false;
        }
        AcceleratedBufferBuilder other = (AcceleratedBufferBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RenderType this$renderType = this.getRenderType();
        RenderType other$renderType = other.getRenderType();
        if (this$renderType == null ? other$renderType != null : !this$renderType.equals(other$renderType)) {
            return false;
        }
        IMemoryLayout<VertexFormatElement> this$layout = this.getLayout();
        IMemoryLayout<VertexFormatElement> other$layout = other.getLayout();
        return !(this$layout == null ? other$layout != null : !this$layout.equals(other$layout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcceleratedBufferBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RenderType $renderType = this.getRenderType();
        result = result * 59 + ($renderType == null ? 43 : $renderType.hashCode());
        IMemoryLayout<VertexFormatElement> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : $layout.hashCode());
        return result;
    }

    @Generated
    public IMemoryInterface getVaryingOffset() {
        return this.varyingOffset;
    }

    @Generated
    public IMemoryInterface getVaryingSharing() {
        return this.varyingSharing;
    }

    @Generated
    public IMemoryInterface getVaryingMesh() {
        return this.varyingMesh;
    }

    @Generated
    public IMemoryInterface getVaryingShouldCull() {
        return this.varyingShouldCull;
    }

    @Generated
    public Map<ServerMesh, MeshUploaderPool.MeshUploader> getMeshUploaders() {
        return this.meshUploaders;
    }

    @Generated
    public StagingBufferPool.StagingBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    @Generated
    public StagingBufferPool.StagingBuffer getVaryingBuffer() {
        return this.varyingBuffer;
    }

    @Generated
    public ElementBufferPool.ElementSegment getElementSegment() {
        return this.elementSegment;
    }

    @Generated
    public AcceleratedRingBuffers.Buffers getBuffer() {
        return this.buffer;
    }

    @Generated
    public ILayerFunction getFunction() {
        return this.function;
    }

    @Override
    @Generated
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.layout;
    }

    @Generated
    public IPolygonProgramDispatcher getPolygonProgramDispatcher() {
        return this.polygonProgramDispatcher;
    }

    @Generated
    public ICullingProgramDispatcher getCullingProgramDispatcher() {
        return this.cullingProgramDispatcher;
    }

    @Generated
    public ITransformShaderProgramOverride getTransformOverride() {
        return this.transformOverride;
    }

    @Generated
    public IUploadingShaderProgramOverride getUploadingOverride() {
        return this.uploadingOverride;
    }

    @Generated
    public VertexFormat.Mode getMode() {
        return this.mode;
    }

    @Override
    @Generated
    public int getPolygonSize() {
        return this.polygonSize;
    }

    @Generated
    public int getPolygonElementCount() {
        return this.polygonElementCount;
    }

    @Generated
    public long getVertexSize() {
        return this.vertexSize;
    }

    @Generated
    public IMemoryInterface getColorOffset() {
        return this.colorOffset;
    }

    @Generated
    public IMemoryInterface getUv1Offset() {
        return this.uv1Offset;
    }

    @Generated
    public IMemoryInterface getUv2Offset() {
        return this.uv2Offset;
    }

    @Generated
    public int getMeshVertexCount() {
        return this.meshVertexCount;
    }

    @Generated
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }
}

