/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.PackedVector2i;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import lombok.Generated;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class SimpleMeshCollector
implements VertexConsumer,
IMeshCollector {
    private final IMemoryLayout<VertexFormatElement> layout;
    private final ByteBufferBuilder buffer;
    private final Vertex vertex;
    private final IMeshData data;
    private final long vertexSize;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private long vertexAddress;
    private int vertexCount;

    public SimpleMeshCollector(IMemoryLayout<VertexFormatElement> layout) {
        this.layout = layout;
        this.buffer = new ByteBufferBuilder(1024);
        this.vertex = new Vertex();
        this.data = CoreFeature.createMeshData(layout);
        this.vertexSize = this.layout.getSize();
        this.posOffset = this.layout.getElement(VertexFormatElement.POSITION);
        this.colorOffset = this.layout.getElement(VertexFormatElement.COLOR);
        this.uv0Offset = this.layout.getElement(VertexFormatElement.UV);
        this.uv2Offset = this.layout.getElement(VertexFormatElement.UV2);
        this.normalOffset = this.layout.getElement(VertexFormatElement.NORMAL);
        this.vertexAddress = -1L;
        this.vertexCount = 0;
    }

    @Override
    public void flush() {
        this.data.addVertex(this.vertex);
    }

    public VertexConsumer addVertex(float pX, float pY, float pZ) {
        if (this.vertexCount != 0) {
            this.data.addVertex(this.vertex);
        }
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        Vector3f vertexPosition = this.vertex.getPosition();
        vertexPosition.x = pX;
        vertexPosition.y = pY;
        vertexPosition.z = pZ;
        return this;
    }

    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        Vector4i vertexColor = this.vertex.getColor();
        vertexColor.x = pRed;
        vertexColor.y = pGreen;
        vertexColor.z = pBlue;
        vertexColor.w = pAlpha;
        return this;
    }

    public VertexConsumer setUv(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        Vector2f vertexUv = this.vertex.getUv();
        vertexUv.x = pU;
        vertexUv.y = pV;
        return this;
    }

    public VertexConsumer setUv1(int pU, int pV) {
        return this;
    }

    public VertexConsumer setUv2(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        Vector2i vertexLight = this.vertex.getLight();
        vertexLight.x = pU;
        vertexLight.y = pV;
        return this;
    }

    public VertexConsumer setNormal(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        Vector3f vertexNormal = this.vertex.getNormal();
        vertexNormal.x = pNormalX;
        vertexNormal.y = pNormalY;
        vertexNormal.z = pNormalZ;
        return this;
    }

    public void addVertex(float pX, float pY, float pZ, int pColor, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        this.colorOffset.putInt(this.vertexAddress, FastColor.ABGR32.fromArgb32((int)pColor));
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        this.uv2Offset.putInt(this.vertexAddress, pPackedLight);
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        this.data.addVertex(pX, pY, pZ, pU, pV, FastColor.ARGB32.red((int)pColor), FastColor.ARGB32.green((int)pColor), FastColor.ARGB32.blue((int)pColor), FastColor.ARGB32.alpha((int)pColor), PackedVector2i.unpackU(pPackedLight), PackedVector2i.unpackV(pPackedLight), pNormalX, pNormalY, pNormalZ);
    }

    @Override
    @Generated
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.layout;
    }

    @Override
    @Generated
    public ByteBufferBuilder getBuffer() {
        return this.buffer;
    }

    @Generated
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    @Generated
    public IMeshData getData() {
        return this.data;
    }

    @Generated
    public long getVertexAddress() {
        return this.vertexAddress;
    }

    @Override
    @Generated
    public int getVertexCount() {
        return this.vertexCount;
    }
}

